package zio.aws.servicequotas.model
import zio.aws.servicequotas.model.primitives.ErrorMessage
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ErrorReason(
    errorCode: Option[zio.aws.servicequotas.model.ErrorCode] = None,
    errorMessage: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.ErrorReason = {
    import ErrorReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.ErrorReason
      .builder()
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.servicequotas.model.ErrorReason.ReadOnly =
    zio.aws.servicequotas.model.ErrorReason.wrap(buildAwsValue())
}
object ErrorReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.ErrorReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicequotas.model.ErrorReason =
      zio.aws.servicequotas.model.ErrorReason(
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def errorCode: Option[zio.aws.servicequotas.model.ErrorCode]
    def errorMessage: Option[ErrorMessage]
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.servicequotas.model.ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.ErrorReason
  ) extends zio.aws.servicequotas.model.ErrorReason.ReadOnly {
    override val errorCode: Option[zio.aws.servicequotas.model.ErrorCode] =
      scala
        .Option(impl.errorCode())
        .map(value => zio.aws.servicequotas.model.ErrorCode.wrap(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.servicequotas.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.ErrorReason
  ): zio.aws.servicequotas.model.ErrorReason.ReadOnly = new Wrapper(impl)
}
