package zio.aws.servicequotas.model
import zio.aws.servicequotas.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Tag(key: TagKey, value: TagValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.Tag
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .value(TagValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.servicequotas.model.Tag.ReadOnly =
    zio.aws.servicequotas.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.servicequotas.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicequotas.model.Tag =
      zio.aws.servicequotas.model.Tag(key, value)
    def key: TagKey
    def value: TagValue
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, TagValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.Tag
  ) extends zio.aws.servicequotas.model.Tag.ReadOnly {
    override val key: TagKey =
      zio.aws.servicequotas.model.primitives.TagKey(impl.key())
    override val value: TagValue =
      zio.aws.servicequotas.model.primitives.TagValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.Tag
  ): zio.aws.servicequotas.model.Tag.ReadOnly = new Wrapper(impl)
}
