package zio.aws.servicequotas.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.servicequotas.model.primitives.PeriodValue
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class QuotaPeriod(
    periodValue: Optional[PeriodValue] = Optional.Absent,
    periodUnit: Optional[zio.aws.servicequotas.model.PeriodUnit] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.QuotaPeriod = {
    import QuotaPeriod.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.QuotaPeriod
      .builder()
      .optionallyWith(
        periodValue.map(value => PeriodValue.unwrap(value): Integer)
      )(_.periodValue)
      .optionallyWith(periodUnit.map(value => value.unwrap))(_.periodUnit)
      .build()
  }
  def asReadOnly: zio.aws.servicequotas.model.QuotaPeriod.ReadOnly =
    zio.aws.servicequotas.model.QuotaPeriod.wrap(buildAwsValue())
}
object QuotaPeriod {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.QuotaPeriod
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicequotas.model.QuotaPeriod =
      zio.aws.servicequotas.model.QuotaPeriod(
        periodValue.map(value => value),
        periodUnit.map(value => value)
      )
    def periodValue: Optional[PeriodValue]
    def periodUnit: Optional[zio.aws.servicequotas.model.PeriodUnit]
    def getPeriodValue: ZIO[Any, AwsError, PeriodValue] =
      AwsError.unwrapOptionField("periodValue", periodValue)
    def getPeriodUnit
        : ZIO[Any, AwsError, zio.aws.servicequotas.model.PeriodUnit] =
      AwsError.unwrapOptionField("periodUnit", periodUnit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.QuotaPeriod
  ) extends zio.aws.servicequotas.model.QuotaPeriod.ReadOnly {
    override val periodValue: Optional[PeriodValue] = zio.aws.core.internal
      .optionalFromNullable(impl.periodValue())
      .map(value => zio.aws.servicequotas.model.primitives.PeriodValue(value))
    override val periodUnit: Optional[zio.aws.servicequotas.model.PeriodUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.periodUnit())
        .map(value => zio.aws.servicequotas.model.PeriodUnit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.QuotaPeriod
  ): zio.aws.servicequotas.model.QuotaPeriod.ReadOnly = new Wrapper(impl)
}
