package zio.aws.servicequotas.model
import zio.aws.servicequotas.model.primitives.{
  AwsRegion,
  QuotaCode,
  ServiceCode
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetServiceQuotaIncreaseRequestFromTemplateRequest(
    serviceCode: ServiceCode,
    quotaCode: QuotaCode,
    awsRegion: AwsRegion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest = {
    import GetServiceQuotaIncreaseRequestFromTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest
      .builder()
      .serviceCode(ServiceCode.unwrap(serviceCode): java.lang.String)
      .quotaCode(QuotaCode.unwrap(quotaCode): java.lang.String)
      .awsRegion(AwsRegion.unwrap(awsRegion): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest.ReadOnly =
    zio.aws.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest
      .wrap(buildAwsValue())
}
object GetServiceQuotaIncreaseRequestFromTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest =
      zio.aws.servicequotas.model
        .GetServiceQuotaIncreaseRequestFromTemplateRequest(
          serviceCode,
          quotaCode,
          awsRegion
        )
    def serviceCode: ServiceCode
    def quotaCode: QuotaCode
    def awsRegion: AwsRegion
    def getServiceCode: ZIO[Any, Nothing, ServiceCode] =
      ZIO.succeed(serviceCode)
    def getQuotaCode: ZIO[Any, Nothing, QuotaCode] = ZIO.succeed(quotaCode)
    def getAwsRegion: ZIO[Any, Nothing, AwsRegion] = ZIO.succeed(awsRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest
  ) extends zio.aws.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest.ReadOnly {
    override val serviceCode: ServiceCode =
      zio.aws.servicequotas.model.primitives.ServiceCode(impl.serviceCode())
    override val quotaCode: QuotaCode =
      zio.aws.servicequotas.model.primitives.QuotaCode(impl.quotaCode())
    override val awsRegion: AwsRegion =
      zio.aws.servicequotas.model.primitives.AwsRegion(impl.awsRegion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest
  ): zio.aws.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
