package zio.aws.servicequotas.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.servicequotas.model.primitives.{MaxResults, NextToken}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListServicesRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.ListServicesRequest = {
    import ListServicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.ListServicesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.servicequotas.model.ListServicesRequest.ReadOnly =
    zio.aws.servicequotas.model.ListServicesRequest.wrap(buildAwsValue())
}
object ListServicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.ListServicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicequotas.model.ListServicesRequest =
      zio.aws.servicequotas.model.ListServicesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.ListServicesRequest
  ) extends zio.aws.servicequotas.model.ListServicesRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.servicequotas.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.servicequotas.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.ListServicesRequest
  ): zio.aws.servicequotas.model.ListServicesRequest.ReadOnly = new Wrapper(
    impl
  )
}
