package zio.aws.servicequotas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAwsDefaultServiceQuotaResponse(
    quota: Optional[zio.aws.servicequotas.model.ServiceQuota] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaResponse = {
    import GetAwsDefaultServiceQuotaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaResponse
      .builder()
      .optionallyWith(quota.map(value => value.buildAwsValue()))(_.quota)
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.GetAwsDefaultServiceQuotaResponse.ReadOnly =
    zio.aws.servicequotas.model.GetAwsDefaultServiceQuotaResponse
      .wrap(buildAwsValue())
}
object GetAwsDefaultServiceQuotaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicequotas.model.GetAwsDefaultServiceQuotaResponse =
      zio.aws.servicequotas.model
        .GetAwsDefaultServiceQuotaResponse(quota.map(value => value.asEditable))
    def quota: Optional[zio.aws.servicequotas.model.ServiceQuota.ReadOnly]
    def getQuota: ZIO[
      Any,
      AwsError,
      zio.aws.servicequotas.model.ServiceQuota.ReadOnly
    ] = AwsError.unwrapOptionField("quota", quota)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaResponse
  ) extends zio.aws.servicequotas.model.GetAwsDefaultServiceQuotaResponse.ReadOnly {
    override val quota
        : Optional[zio.aws.servicequotas.model.ServiceQuota.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quota())
        .map(value => zio.aws.servicequotas.model.ServiceQuota.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaResponse
  ): zio.aws.servicequotas.model.GetAwsDefaultServiceQuotaResponse.ReadOnly =
    new Wrapper(impl)
}
