package zio.aws.servicequotas.model
import zio.aws.servicequotas.model.primitives.{
  QuotaUnit,
  QuotaCode,
  GlobalQuota,
  ServiceCode,
  QuotaValue,
  AwsRegion,
  QuotaName,
  ServiceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServiceQuotaIncreaseRequestInTemplate(
    serviceCode: Optional[ServiceCode] = Optional.Absent,
    serviceName: Optional[ServiceName] = Optional.Absent,
    quotaCode: Optional[QuotaCode] = Optional.Absent,
    quotaName: Optional[QuotaName] = Optional.Absent,
    desiredValue: Optional[QuotaValue] = Optional.Absent,
    awsRegion: Optional[AwsRegion] = Optional.Absent,
    unit: Optional[QuotaUnit] = Optional.Absent,
    globalQuota: Optional[GlobalQuota] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate = {
    import ServiceQuotaIncreaseRequestInTemplate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate
      .builder()
      .optionallyWith(
        serviceCode.map(value => ServiceCode.unwrap(value): java.lang.String)
      )(_.serviceCode)
      .optionallyWith(
        serviceName.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .optionallyWith(
        quotaCode.map(value => QuotaCode.unwrap(value): java.lang.String)
      )(_.quotaCode)
      .optionallyWith(
        quotaName.map(value => QuotaName.unwrap(value): java.lang.String)
      )(_.quotaName)
      .optionallyWith(
        desiredValue.map(value => QuotaValue.unwrap(value): java.lang.Double)
      )(_.desiredValue)
      .optionallyWith(
        awsRegion.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.awsRegion)
      .optionallyWith(
        unit.map(value => QuotaUnit.unwrap(value): java.lang.String)
      )(_.unit)
      .optionallyWith(
        globalQuota.map(value => GlobalQuota.unwrap(value): java.lang.Boolean)
      )(_.globalQuota)
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate.ReadOnly =
    zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate
      .wrap(buildAwsValue())
}
object ServiceQuotaIncreaseRequestInTemplate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate =
      zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate(
        serviceCode.map(value => value),
        serviceName.map(value => value),
        quotaCode.map(value => value),
        quotaName.map(value => value),
        desiredValue.map(value => value),
        awsRegion.map(value => value),
        unit.map(value => value),
        globalQuota.map(value => value)
      )
    def serviceCode: Optional[ServiceCode]
    def serviceName: Optional[ServiceName]
    def quotaCode: Optional[QuotaCode]
    def quotaName: Optional[QuotaName]
    def desiredValue: Optional[QuotaValue]
    def awsRegion: Optional[AwsRegion]
    def unit: Optional[QuotaUnit]
    def globalQuota: Optional[GlobalQuota]
    def getServiceCode: ZIO[Any, AwsError, ServiceCode] =
      AwsError.unwrapOptionField("serviceCode", serviceCode)
    def getServiceName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getQuotaCode: ZIO[Any, AwsError, QuotaCode] =
      AwsError.unwrapOptionField("quotaCode", quotaCode)
    def getQuotaName: ZIO[Any, AwsError, QuotaName] =
      AwsError.unwrapOptionField("quotaName", quotaName)
    def getDesiredValue: ZIO[Any, AwsError, QuotaValue] =
      AwsError.unwrapOptionField("desiredValue", desiredValue)
    def getAwsRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
    def getUnit: ZIO[Any, AwsError, QuotaUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getGlobalQuota: ZIO[Any, AwsError, GlobalQuota] =
      AwsError.unwrapOptionField("globalQuota", globalQuota)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate
  ) extends zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate.ReadOnly {
    override val serviceCode: Optional[ServiceCode] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceCode())
      .map(value => zio.aws.servicequotas.model.primitives.ServiceCode(value))
    override val serviceName: Optional[ServiceName] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => zio.aws.servicequotas.model.primitives.ServiceName(value))
    override val quotaCode: Optional[QuotaCode] = zio.aws.core.internal
      .optionalFromNullable(impl.quotaCode())
      .map(value => zio.aws.servicequotas.model.primitives.QuotaCode(value))
    override val quotaName: Optional[QuotaName] = zio.aws.core.internal
      .optionalFromNullable(impl.quotaName())
      .map(value => zio.aws.servicequotas.model.primitives.QuotaName(value))
    override val desiredValue: Optional[QuotaValue] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredValue())
      .map(value => zio.aws.servicequotas.model.primitives.QuotaValue(value))
    override val awsRegion: Optional[AwsRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.awsRegion())
      .map(value => zio.aws.servicequotas.model.primitives.AwsRegion(value))
    override val unit: Optional[QuotaUnit] = zio.aws.core.internal
      .optionalFromNullable(impl.unit())
      .map(value => zio.aws.servicequotas.model.primitives.QuotaUnit(value))
    override val globalQuota: Optional[GlobalQuota] = zio.aws.core.internal
      .optionalFromNullable(impl.globalQuota())
      .map(value => zio.aws.servicequotas.model.primitives.GlobalQuota(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate
  ): zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate.ReadOnly =
    new Wrapper(impl)
}
