package zio.aws.servicequotas.model
import zio.aws.servicequotas.model.primitives.{QuotaCode, ServiceCode}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetServiceQuotaRequest(
    serviceCode: ServiceCode,
    quotaCode: QuotaCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaRequest = {
    import GetServiceQuotaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaRequest
      .builder()
      .serviceCode(ServiceCode.unwrap(serviceCode): java.lang.String)
      .quotaCode(QuotaCode.unwrap(quotaCode): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.servicequotas.model.GetServiceQuotaRequest.ReadOnly =
    zio.aws.servicequotas.model.GetServiceQuotaRequest.wrap(buildAwsValue())
}
object GetServiceQuotaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicequotas.model.GetServiceQuotaRequest =
      zio.aws.servicequotas.model.GetServiceQuotaRequest(serviceCode, quotaCode)
    def serviceCode: ServiceCode
    def quotaCode: QuotaCode
    def getServiceCode: ZIO[Any, Nothing, ServiceCode] =
      ZIO.succeed(serviceCode)
    def getQuotaCode: ZIO[Any, Nothing, QuotaCode] = ZIO.succeed(quotaCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaRequest
  ) extends zio.aws.servicequotas.model.GetServiceQuotaRequest.ReadOnly {
    override val serviceCode: ServiceCode =
      zio.aws.servicequotas.model.primitives.ServiceCode(impl.serviceCode())
    override val quotaCode: QuotaCode =
      zio.aws.servicequotas.model.primitives.QuotaCode(impl.quotaCode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaRequest
  ): zio.aws.servicequotas.model.GetServiceQuotaRequest.ReadOnly = new Wrapper(
    impl
  )
}
