package zio.aws.servicequotas.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RequestServiceQuotaIncreaseResponse(
    requestedQuota: Optional[
      zio.aws.servicequotas.model.RequestedServiceQuotaChange
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseResponse = {
    import RequestServiceQuotaIncreaseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseResponse
      .builder()
      .optionallyWith(requestedQuota.map(value => value.buildAwsValue()))(
        _.requestedQuota
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.RequestServiceQuotaIncreaseResponse.ReadOnly =
    zio.aws.servicequotas.model.RequestServiceQuotaIncreaseResponse
      .wrap(buildAwsValue())
}
object RequestServiceQuotaIncreaseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicequotas.model.RequestServiceQuotaIncreaseResponse =
      zio.aws.servicequotas.model.RequestServiceQuotaIncreaseResponse(
        requestedQuota.map(value => value.asEditable)
      )
    def requestedQuota: Optional[
      zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly
    ]
    def getRequestedQuota: ZIO[
      Any,
      AwsError,
      zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly
    ] = AwsError.unwrapOptionField("requestedQuota", requestedQuota)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseResponse
  ) extends zio.aws.servicequotas.model.RequestServiceQuotaIncreaseResponse.ReadOnly {
    override val requestedQuota: Optional[
      zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.requestedQuota())
      .map(value =>
        zio.aws.servicequotas.model.RequestedServiceQuotaChange.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseResponse
  ): zio.aws.servicequotas.model.RequestServiceQuotaIncreaseResponse.ReadOnly =
    new Wrapper(impl)
}
