package zio.aws.servicequotas.model
import zio.aws.servicequotas.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListServiceQuotaIncreaseRequestsInTemplateResponse(
    serviceQuotaIncreaseRequestInTemplateList: Optional[Iterable[
      zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate
    ]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse = {
    import ListServiceQuotaIncreaseRequestsInTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse
      .builder()
      .optionallyWith(
        serviceQuotaIncreaseRequestInTemplateList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceQuotaIncreaseRequestInTemplateList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse.ReadOnly =
    zio.aws.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse
      .wrap(buildAwsValue())
}
object ListServiceQuotaIncreaseRequestsInTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse =
      zio.aws.servicequotas.model
        .ListServiceQuotaIncreaseRequestsInTemplateResponse(
          serviceQuotaIncreaseRequestInTemplateList.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def serviceQuotaIncreaseRequestInTemplateList: Optional[List[
      zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate.ReadOnly
    ]]
    def nextToken: Optional[NextToken]
    def getServiceQuotaIncreaseRequestInTemplateList: ZIO[Any, AwsError, List[
      zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "serviceQuotaIncreaseRequestInTemplateList",
      serviceQuotaIncreaseRequestInTemplateList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse
  ) extends zio.aws.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse.ReadOnly {
    override val serviceQuotaIncreaseRequestInTemplateList: Optional[List[
      zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceQuotaIncreaseRequestInTemplateList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.servicequotas.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse
  ): zio.aws.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
