package zio.aws.servicequotas.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.servicequotas.model.primitives.{
  MaxResults,
  NextToken,
  QuotaCode,
  ServiceCode
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRequestedServiceQuotaChangeHistoryByQuotaRequest(
    serviceCode: ServiceCode,
    quotaCode: QuotaCode,
    status: Optional[zio.aws.servicequotas.model.RequestStatus] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest = {
    import ListRequestedServiceQuotaChangeHistoryByQuotaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest
      .builder()
      .serviceCode(ServiceCode.unwrap(serviceCode): java.lang.String)
      .quotaCode(QuotaCode.unwrap(quotaCode): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest.ReadOnly =
    zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest
      .wrap(buildAwsValue())
}
object ListRequestedServiceQuotaChangeHistoryByQuotaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest =
      zio.aws.servicequotas.model
        .ListRequestedServiceQuotaChangeHistoryByQuotaRequest(
          serviceCode,
          quotaCode,
          status.map(value => value),
          nextToken.map(value => value),
          maxResults.map(value => value)
        )
    def serviceCode: ServiceCode
    def quotaCode: QuotaCode
    def status: Optional[zio.aws.servicequotas.model.RequestStatus]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getServiceCode: ZIO[Any, Nothing, ServiceCode] =
      ZIO.succeed(serviceCode)
    def getQuotaCode: ZIO[Any, Nothing, QuotaCode] = ZIO.succeed(quotaCode)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.servicequotas.model.RequestStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest
  ) extends zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest.ReadOnly {
    override val serviceCode: ServiceCode =
      zio.aws.servicequotas.model.primitives.ServiceCode(impl.serviceCode())
    override val quotaCode: QuotaCode =
      zio.aws.servicequotas.model.primitives.QuotaCode(impl.quotaCode())
    override val status: Optional[zio.aws.servicequotas.model.RequestStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.servicequotas.model.RequestStatus.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.servicequotas.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.servicequotas.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest
  ): zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest.ReadOnly =
    new Wrapper(impl)
}
