package zio.aws.servicequotas.model
import zio.aws.servicequotas.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListRequestedServiceQuotaChangeHistoryByQuotaResponse(
    nextToken: Option[NextToken] = None,
    requestedQuotas: Option[
      Iterable[zio.aws.servicequotas.model.RequestedServiceQuotaChange]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse = {
    import ListRequestedServiceQuotaChangeHistoryByQuotaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        requestedQuotas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requestedQuotas)
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse.ReadOnly =
    zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse
      .wrap(buildAwsValue())
}
object ListRequestedServiceQuotaChangeHistoryByQuotaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse =
      zio.aws.servicequotas.model
        .ListRequestedServiceQuotaChangeHistoryByQuotaResponse(
          nextToken.map(value => value),
          requestedQuotas.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def nextToken: Option[NextToken]
    def requestedQuotas: Option[
      List[zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRequestedQuotas: ZIO[Any, AwsError, List[
      zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly
    ]] = AwsError.unwrapOptionField("requestedQuotas", requestedQuotas)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse
  ) extends zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.servicequotas.model.primitives.NextToken(value))
    override val requestedQuotas: Option[
      List[zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly]
    ] = scala
      .Option(impl.requestedQuotas())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicequotas.model.RequestedServiceQuotaChange.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse
  ): zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse.ReadOnly =
    new Wrapper(impl)
}
