package zio.aws.servicequotas
import zio.aws.servicequotas.model.ServiceInfo.ReadOnly
import zio.aws.servicequotas.model.{
  GetAwsDefaultServiceQuotaRequest,
  AssociateServiceQuotaTemplateRequest,
  ListRequestedServiceQuotaChangeHistoryRequest,
  ListAwsDefaultServiceQuotasRequest,
  GetServiceQuotaRequest,
  PutServiceQuotaIncreaseRequestIntoTemplateRequest,
  ListRequestedServiceQuotaChangeHistoryByQuotaRequest,
  ListTagsForResourceRequest,
  UntagResourceRequest,
  RequestServiceQuotaIncreaseRequest,
  GetAssociationForServiceQuotaTemplateRequest,
  ListServicesRequest,
  ListServiceQuotasRequest,
  DisassociateServiceQuotaTemplateRequest,
  ListServiceQuotaIncreaseRequestsInTemplateRequest,
  DeleteServiceQuotaIncreaseRequestFromTemplateRequest,
  GetRequestedServiceQuotaChangeRequest,
  GetServiceQuotaIncreaseRequestFromTemplateRequest,
  TagResourceRequest
}
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.servicequotas.ServiceQuotasAsyncClient
import zio.stream.ZStream
object ServiceQuotasMock extends Mock[ServiceQuotas] {
  object DeleteServiceQuotaIncreaseRequestFromTemplate
      extends Effect[
        DeleteServiceQuotaIncreaseRequestFromTemplateRequest,
        AwsError,
        zio.aws.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateResponse.ReadOnly
      ]
  object ListServiceQuotas
      extends Stream[
        ListServiceQuotasRequest,
        AwsError,
        zio.aws.servicequotas.model.ServiceQuota.ReadOnly
      ]
  object ListServiceQuotasPaginated
      extends Effect[
        ListServiceQuotasRequest,
        AwsError,
        zio.aws.servicequotas.model.ListServiceQuotasResponse.ReadOnly
      ]
  object DisassociateServiceQuotaTemplate
      extends Effect[
        DisassociateServiceQuotaTemplateRequest,
        AwsError,
        zio.aws.servicequotas.model.DisassociateServiceQuotaTemplateResponse.ReadOnly
      ]
  object RequestServiceQuotaIncrease
      extends Effect[
        RequestServiceQuotaIncreaseRequest,
        AwsError,
        zio.aws.servicequotas.model.RequestServiceQuotaIncreaseResponse.ReadOnly
      ]
  object PutServiceQuotaIncreaseRequestIntoTemplate
      extends Effect[
        PutServiceQuotaIncreaseRequestIntoTemplateRequest,
        AwsError,
        zio.aws.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse.ReadOnly
      ]
  object GetAWSDefaultServiceQuota
      extends Effect[
        GetAwsDefaultServiceQuotaRequest,
        AwsError,
        zio.aws.servicequotas.model.GetAwsDefaultServiceQuotaResponse.ReadOnly
      ]
  object ListServices extends Stream[ListServicesRequest, AwsError, ReadOnly]
  object ListServicesPaginated
      extends Effect[
        ListServicesRequest,
        AwsError,
        zio.aws.servicequotas.model.ListServicesResponse.ReadOnly
      ]
  object GetServiceQuota
      extends Effect[
        GetServiceQuotaRequest,
        AwsError,
        zio.aws.servicequotas.model.GetServiceQuotaResponse.ReadOnly
      ]
  object AssociateServiceQuotaTemplate
      extends Effect[
        AssociateServiceQuotaTemplateRequest,
        AwsError,
        zio.aws.servicequotas.model.AssociateServiceQuotaTemplateResponse.ReadOnly
      ]
  object ListAWSDefaultServiceQuotas
      extends Stream[
        ListAwsDefaultServiceQuotasRequest,
        AwsError,
        zio.aws.servicequotas.model.ServiceQuota.ReadOnly
      ]
  object ListAWSDefaultServiceQuotasPaginated
      extends Effect[
        ListAwsDefaultServiceQuotasRequest,
        AwsError,
        zio.aws.servicequotas.model.ListAwsDefaultServiceQuotasResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.servicequotas.model.UntagResourceResponse.ReadOnly
      ]
  object GetServiceQuotaIncreaseRequestFromTemplate
      extends Effect[
        GetServiceQuotaIncreaseRequestFromTemplateRequest,
        AwsError,
        zio.aws.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateResponse.ReadOnly
      ]
  object GetAssociationForServiceQuotaTemplate
      extends Effect[
        GetAssociationForServiceQuotaTemplateRequest,
        AwsError,
        zio.aws.servicequotas.model.GetAssociationForServiceQuotaTemplateResponse.ReadOnly
      ]
  object GetRequestedServiceQuotaChange
      extends Effect[
        GetRequestedServiceQuotaChangeRequest,
        AwsError,
        zio.aws.servicequotas.model.GetRequestedServiceQuotaChangeResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.servicequotas.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.servicequotas.model.TagResourceResponse.ReadOnly
      ]
  object ListServiceQuotaIncreaseRequestsInTemplate
      extends Stream[
        ListServiceQuotaIncreaseRequestsInTemplateRequest,
        AwsError,
        zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate.ReadOnly
      ]
  object ListServiceQuotaIncreaseRequestsInTemplatePaginated
      extends Effect[
        ListServiceQuotaIncreaseRequestsInTemplateRequest,
        AwsError,
        zio.aws.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse.ReadOnly
      ]
  object ListRequestedServiceQuotaChangeHistory
      extends Stream[
        ListRequestedServiceQuotaChangeHistoryRequest,
        AwsError,
        zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly
      ]
  object ListRequestedServiceQuotaChangeHistoryPaginated
      extends Effect[
        ListRequestedServiceQuotaChangeHistoryRequest,
        AwsError,
        zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse.ReadOnly
      ]
  object ListRequestedServiceQuotaChangeHistoryByQuota
      extends Stream[
        ListRequestedServiceQuotaChangeHistoryByQuotaRequest,
        AwsError,
        zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly
      ]
  object ListRequestedServiceQuotaChangeHistoryByQuotaPaginated
      extends Effect[
        ListRequestedServiceQuotaChangeHistoryByQuotaRequest,
        AwsError,
        zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ServiceQuotas] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new ServiceQuotas {
          val api: ServiceQuotasAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : ServiceQuotas = this
          def deleteServiceQuotaIncreaseRequestFromTemplate(
              request: DeleteServiceQuotaIncreaseRequestFromTemplateRequest
          ): IO[
            AwsError,
            zio.aws.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateResponse.ReadOnly
          ] = proxy(DeleteServiceQuotaIncreaseRequestFromTemplate, request)
          def listServiceQuotas(request: ListServiceQuotasRequest): ZStream[
            Any,
            AwsError,
            zio.aws.servicequotas.model.ServiceQuota.ReadOnly
          ] = rts.unsafeRun(proxy(ListServiceQuotas, request))
          def listServiceQuotasPaginated(request: ListServiceQuotasRequest): IO[
            AwsError,
            zio.aws.servicequotas.model.ListServiceQuotasResponse.ReadOnly
          ] = proxy(ListServiceQuotasPaginated, request)
          def disassociateServiceQuotaTemplate(
              request: DisassociateServiceQuotaTemplateRequest
          ): IO[
            AwsError,
            zio.aws.servicequotas.model.DisassociateServiceQuotaTemplateResponse.ReadOnly
          ] = proxy(DisassociateServiceQuotaTemplate, request)
          def requestServiceQuotaIncrease(
              request: RequestServiceQuotaIncreaseRequest
          ): IO[
            AwsError,
            zio.aws.servicequotas.model.RequestServiceQuotaIncreaseResponse.ReadOnly
          ] = proxy(RequestServiceQuotaIncrease, request)
          def putServiceQuotaIncreaseRequestIntoTemplate(
              request: PutServiceQuotaIncreaseRequestIntoTemplateRequest
          ): IO[
            AwsError,
            zio.aws.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse.ReadOnly
          ] = proxy(PutServiceQuotaIncreaseRequestIntoTemplate, request)
          def getAWSDefaultServiceQuota(
              request: GetAwsDefaultServiceQuotaRequest
          ): IO[
            AwsError,
            zio.aws.servicequotas.model.GetAwsDefaultServiceQuotaResponse.ReadOnly
          ] = proxy(GetAWSDefaultServiceQuota, request)
          def listServices(
              request: ListServicesRequest
          ): ZStream[Any, AwsError, ReadOnly] =
            rts.unsafeRun(proxy(ListServices, request))
          def listServicesPaginated(request: ListServicesRequest): IO[
            AwsError,
            zio.aws.servicequotas.model.ListServicesResponse.ReadOnly
          ] = proxy(ListServicesPaginated, request)
          def getServiceQuota(request: GetServiceQuotaRequest): IO[
            AwsError,
            zio.aws.servicequotas.model.GetServiceQuotaResponse.ReadOnly
          ] = proxy(GetServiceQuota, request)
          def associateServiceQuotaTemplate(
              request: AssociateServiceQuotaTemplateRequest
          ): IO[
            AwsError,
            zio.aws.servicequotas.model.AssociateServiceQuotaTemplateResponse.ReadOnly
          ] = proxy(AssociateServiceQuotaTemplate, request)
          def listAWSDefaultServiceQuotas(
              request: ListAwsDefaultServiceQuotasRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.servicequotas.model.ServiceQuota.ReadOnly
          ] = rts.unsafeRun(proxy(ListAWSDefaultServiceQuotas, request))
          def listAWSDefaultServiceQuotasPaginated(
              request: ListAwsDefaultServiceQuotasRequest
          ): IO[
            AwsError,
            zio.aws.servicequotas.model.ListAwsDefaultServiceQuotasResponse.ReadOnly
          ] = proxy(ListAWSDefaultServiceQuotasPaginated, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.servicequotas.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def getServiceQuotaIncreaseRequestFromTemplate(
              request: GetServiceQuotaIncreaseRequestFromTemplateRequest
          ): IO[
            AwsError,
            zio.aws.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateResponse.ReadOnly
          ] = proxy(GetServiceQuotaIncreaseRequestFromTemplate, request)
          def getAssociationForServiceQuotaTemplate(
              request: GetAssociationForServiceQuotaTemplateRequest
          ): IO[
            AwsError,
            zio.aws.servicequotas.model.GetAssociationForServiceQuotaTemplateResponse.ReadOnly
          ] = proxy(GetAssociationForServiceQuotaTemplate, request)
          def getRequestedServiceQuotaChange(
              request: GetRequestedServiceQuotaChangeRequest
          ): IO[
            AwsError,
            zio.aws.servicequotas.model.GetRequestedServiceQuotaChangeResponse.ReadOnly
          ] = proxy(GetRequestedServiceQuotaChange, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.servicequotas.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.servicequotas.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def listServiceQuotaIncreaseRequestsInTemplate(
              request: ListServiceQuotaIncreaseRequestsInTemplateRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate.ReadOnly
          ] = rts.unsafeRun(
            proxy(ListServiceQuotaIncreaseRequestsInTemplate, request)
          )
          def listServiceQuotaIncreaseRequestsInTemplatePaginated(
              request: ListServiceQuotaIncreaseRequestsInTemplateRequest
          ): IO[
            AwsError,
            zio.aws.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse.ReadOnly
          ] =
            proxy(ListServiceQuotaIncreaseRequestsInTemplatePaginated, request)
          def listRequestedServiceQuotaChangeHistory(
              request: ListRequestedServiceQuotaChangeHistoryRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly
          ] = rts.unsafeRun(
            proxy(ListRequestedServiceQuotaChangeHistory, request)
          )
          def listRequestedServiceQuotaChangeHistoryPaginated(
              request: ListRequestedServiceQuotaChangeHistoryRequest
          ): IO[
            AwsError,
            zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse.ReadOnly
          ] = proxy(ListRequestedServiceQuotaChangeHistoryPaginated, request)
          def listRequestedServiceQuotaChangeHistoryByQuota(
              request: ListRequestedServiceQuotaChangeHistoryByQuotaRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly
          ] = rts.unsafeRun(
            proxy(ListRequestedServiceQuotaChangeHistoryByQuota, request)
          )
          def listRequestedServiceQuotaChangeHistoryByQuotaPaginated(
              request: ListRequestedServiceQuotaChangeHistoryByQuotaRequest
          ): IO[
            AwsError,
            zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse.ReadOnly
          ] = proxy(
            ListRequestedServiceQuotaChangeHistoryByQuotaPaginated,
            request
          )
        }
      }
    }
    .toLayer
}
