package zio.aws.servicequotas
import zio.aws.servicequotas.model.ServiceInfo.ReadOnly
import zio.aws.servicequotas.model.{
  GetAwsDefaultServiceQuotaRequest,
  AssociateServiceQuotaTemplateRequest,
  ListRequestedServiceQuotaChangeHistoryRequest,
  ListAwsDefaultServiceQuotasRequest,
  GetServiceQuotaRequest,
  PutServiceQuotaIncreaseRequestIntoTemplateRequest,
  ListRequestedServiceQuotaChangeHistoryByQuotaRequest,
  ListTagsForResourceRequest,
  UntagResourceRequest,
  RequestServiceQuotaIncreaseRequest,
  GetAssociationForServiceQuotaTemplateRequest,
  ListServicesRequest,
  ListServiceQuotasRequest,
  DisassociateServiceQuotaTemplateRequest,
  ListServiceQuotaIncreaseRequestsInTemplateRequest,
  DeleteServiceQuotaIncreaseRequestFromTemplateRequest,
  GetRequestedServiceQuotaChangeRequest,
  GetServiceQuotaIncreaseRequestFromTemplateRequest,
  TagResourceRequest
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.servicequotas.{
  ServiceQuotasAsyncClientBuilder,
  ServiceQuotasAsyncClient
}
import zio.stream.ZStream
import software.amazon.awssdk.services.servicequotas.model.{
  ListRequestedServiceQuotaChangeHistoryResponse,
  ListRequestedServiceQuotaChangeHistoryByQuotaResponse,
  PutServiceQuotaIncreaseRequestIntoTemplateResponse,
  ServiceQuota,
  DeleteServiceQuotaIncreaseRequestFromTemplateResponse,
  DisassociateServiceQuotaTemplateResponse,
  ListAwsDefaultServiceQuotasResponse,
  ListTagsForResourceResponse,
  GetRequestedServiceQuotaChangeResponse,
  UntagResourceResponse,
  GetServiceQuotaResponse,
  ListServiceQuotasResponse,
  GetServiceQuotaIncreaseRequestFromTemplateResponse,
  RequestServiceQuotaIncreaseResponse,
  ServiceInfo,
  GetAssociationForServiceQuotaTemplateResponse,
  GetAwsDefaultServiceQuotaResponse,
  RequestedServiceQuotaChange,
  TagResourceResponse,
  ListServiceQuotaIncreaseRequestsInTemplateResponse,
  AssociateServiceQuotaTemplateResponse,
  ServiceQuotaIncreaseRequestInTemplate,
  ListServicesResponse
}
import scala.jdk.CollectionConverters._
trait ServiceQuotas extends AspectSupport[ServiceQuotas] {
  val api: ServiceQuotasAsyncClient
  def deleteServiceQuotaIncreaseRequestFromTemplate(
      request: DeleteServiceQuotaIncreaseRequestFromTemplateRequest
  ): IO[
    AwsError,
    zio.aws.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateResponse.ReadOnly
  ]
  def listServiceQuotas(
      request: ListServiceQuotasRequest
  ): ZStream[Any, AwsError, zio.aws.servicequotas.model.ServiceQuota.ReadOnly]
  def listServiceQuotasPaginated(request: ListServiceQuotasRequest): IO[
    AwsError,
    zio.aws.servicequotas.model.ListServiceQuotasResponse.ReadOnly
  ]
  def disassociateServiceQuotaTemplate(
      request: DisassociateServiceQuotaTemplateRequest
  ): IO[
    AwsError,
    zio.aws.servicequotas.model.DisassociateServiceQuotaTemplateResponse.ReadOnly
  ]
  def requestServiceQuotaIncrease(
      request: RequestServiceQuotaIncreaseRequest
  ): IO[
    AwsError,
    zio.aws.servicequotas.model.RequestServiceQuotaIncreaseResponse.ReadOnly
  ]
  def putServiceQuotaIncreaseRequestIntoTemplate(
      request: PutServiceQuotaIncreaseRequestIntoTemplateRequest
  ): IO[
    AwsError,
    zio.aws.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse.ReadOnly
  ]
  def getAWSDefaultServiceQuota(request: GetAwsDefaultServiceQuotaRequest): IO[
    AwsError,
    zio.aws.servicequotas.model.GetAwsDefaultServiceQuotaResponse.ReadOnly
  ]
  def listServices(
      request: ListServicesRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listServicesPaginated(
      request: ListServicesRequest
  ): IO[AwsError, zio.aws.servicequotas.model.ListServicesResponse.ReadOnly]
  def getServiceQuota(
      request: GetServiceQuotaRequest
  ): IO[AwsError, zio.aws.servicequotas.model.GetServiceQuotaResponse.ReadOnly]
  def associateServiceQuotaTemplate(
      request: AssociateServiceQuotaTemplateRequest
  ): IO[
    AwsError,
    zio.aws.servicequotas.model.AssociateServiceQuotaTemplateResponse.ReadOnly
  ]
  def listAWSDefaultServiceQuotas(
      request: ListAwsDefaultServiceQuotasRequest
  ): ZStream[Any, AwsError, zio.aws.servicequotas.model.ServiceQuota.ReadOnly]
  def listAWSDefaultServiceQuotasPaginated(
      request: ListAwsDefaultServiceQuotasRequest
  ): IO[
    AwsError,
    zio.aws.servicequotas.model.ListAwsDefaultServiceQuotasResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.servicequotas.model.UntagResourceResponse.ReadOnly]
  def getServiceQuotaIncreaseRequestFromTemplate(
      request: GetServiceQuotaIncreaseRequestFromTemplateRequest
  ): IO[
    AwsError,
    zio.aws.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateResponse.ReadOnly
  ]
  def getAssociationForServiceQuotaTemplate(
      request: GetAssociationForServiceQuotaTemplateRequest
  ): IO[
    AwsError,
    zio.aws.servicequotas.model.GetAssociationForServiceQuotaTemplateResponse.ReadOnly
  ]
  def getRequestedServiceQuotaChange(
      request: GetRequestedServiceQuotaChangeRequest
  ): IO[
    AwsError,
    zio.aws.servicequotas.model.GetRequestedServiceQuotaChangeResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.servicequotas.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.servicequotas.model.TagResourceResponse.ReadOnly]
  def listServiceQuotaIncreaseRequestsInTemplate(
      request: ListServiceQuotaIncreaseRequestsInTemplateRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate.ReadOnly
  ]
  def listServiceQuotaIncreaseRequestsInTemplatePaginated(
      request: ListServiceQuotaIncreaseRequestsInTemplateRequest
  ): IO[
    AwsError,
    zio.aws.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse.ReadOnly
  ]
  def listRequestedServiceQuotaChangeHistory(
      request: ListRequestedServiceQuotaChangeHistoryRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly
  ]
  def listRequestedServiceQuotaChangeHistoryPaginated(
      request: ListRequestedServiceQuotaChangeHistoryRequest
  ): IO[
    AwsError,
    zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse.ReadOnly
  ]
  def listRequestedServiceQuotaChangeHistoryByQuota(
      request: ListRequestedServiceQuotaChangeHistoryByQuotaRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly
  ]
  def listRequestedServiceQuotaChangeHistoryByQuotaPaginated(
      request: ListRequestedServiceQuotaChangeHistoryByQuotaRequest
  ): IO[
    AwsError,
    zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse.ReadOnly
  ]
}
object ServiceQuotas {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ServiceQuotas] = customized(
    identity
  )
  def customized(
      customization: ServiceQuotasAsyncClientBuilder => ServiceQuotasAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ServiceQuotas] = managed(
    customization
  ).toLayer
  def managed(
      customization: ServiceQuotasAsyncClientBuilder => ServiceQuotasAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, ServiceQuotas] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = ServiceQuotasAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[ServiceQuotasAsyncClient, ServiceQuotasAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        ServiceQuotasAsyncClient,
        ServiceQuotasAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new ServiceQuotasImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ServiceQuotasImpl[R](
      override val api: ServiceQuotasAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ServiceQuotas
      with AwsServiceBase[R] {
    override val serviceName: String = "ServiceQuotas"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ServiceQuotasImpl[R1] = new ServiceQuotasImpl(api, newAspect, r)
    def deleteServiceQuotaIncreaseRequestFromTemplate(
        request: DeleteServiceQuotaIncreaseRequestFromTemplateRequest
    ): IO[
      AwsError,
      zio.aws.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest,
      DeleteServiceQuotaIncreaseRequestFromTemplateResponse
    ](
      "deleteServiceQuotaIncreaseRequestFromTemplate",
      api.deleteServiceQuotaIncreaseRequestFromTemplate
    )(request.buildAwsValue())
      .map(
        zio.aws.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateResponse.wrap
      )
      .provideEnvironment(r)
    def listServiceQuotas(request: ListServiceQuotasRequest): ZStream[
      Any,
      AwsError,
      zio.aws.servicequotas.model.ServiceQuota.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest,
      ListServiceQuotasResponse,
      ServiceQuota
    ](
      "listServiceQuotas",
      api.listServiceQuotas,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.quotas().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.servicequotas.model.ServiceQuota.wrap(item))
      .provideEnvironment(r)
    def listServiceQuotasPaginated(request: ListServiceQuotasRequest): IO[
      AwsError,
      zio.aws.servicequotas.model.ListServiceQuotasResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest,
      ListServiceQuotasResponse
    ]("listServiceQuotas", api.listServiceQuotas)(request.buildAwsValue())
      .map(zio.aws.servicequotas.model.ListServiceQuotasResponse.wrap)
      .provideEnvironment(r)
    def disassociateServiceQuotaTemplate(
        request: DisassociateServiceQuotaTemplateRequest
    ): IO[
      AwsError,
      zio.aws.servicequotas.model.DisassociateServiceQuotaTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicequotas.model.DisassociateServiceQuotaTemplateRequest,
      DisassociateServiceQuotaTemplateResponse
    ]("disassociateServiceQuotaTemplate", api.disassociateServiceQuotaTemplate)(
      request.buildAwsValue()
    ).map(
      zio.aws.servicequotas.model.DisassociateServiceQuotaTemplateResponse.wrap
    ).provideEnvironment(r)
    def requestServiceQuotaIncrease(
        request: RequestServiceQuotaIncreaseRequest
    ): IO[
      AwsError,
      zio.aws.servicequotas.model.RequestServiceQuotaIncreaseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseRequest,
      RequestServiceQuotaIncreaseResponse
    ]("requestServiceQuotaIncrease", api.requestServiceQuotaIncrease)(
      request.buildAwsValue()
    ).map(zio.aws.servicequotas.model.RequestServiceQuotaIncreaseResponse.wrap)
      .provideEnvironment(r)
    def putServiceQuotaIncreaseRequestIntoTemplate(
        request: PutServiceQuotaIncreaseRequestIntoTemplateRequest
    ): IO[
      AwsError,
      zio.aws.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest,
      PutServiceQuotaIncreaseRequestIntoTemplateResponse
    ](
      "putServiceQuotaIncreaseRequestIntoTemplate",
      api.putServiceQuotaIncreaseRequestIntoTemplate
    )(request.buildAwsValue())
      .map(
        zio.aws.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse.wrap
      )
      .provideEnvironment(r)
    def getAWSDefaultServiceQuota(
        request: GetAwsDefaultServiceQuotaRequest
    ): IO[
      AwsError,
      zio.aws.servicequotas.model.GetAwsDefaultServiceQuotaResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaRequest,
      GetAwsDefaultServiceQuotaResponse
    ]("getAWSDefaultServiceQuota", api.getAWSDefaultServiceQuota)(
      request.buildAwsValue()
    ).map(zio.aws.servicequotas.model.GetAwsDefaultServiceQuotaResponse.wrap)
      .provideEnvironment(r)
    def listServices(
        request: ListServicesRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.servicequotas.model.ListServicesRequest,
      ListServicesResponse,
      ServiceInfo
    ](
      "listServices",
      api.listServices,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.services().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.servicequotas.model.ServiceInfo.wrap(item))
      .provideEnvironment(r)
    def listServicesPaginated(
        request: ListServicesRequest
    ): IO[AwsError, zio.aws.servicequotas.model.ListServicesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.servicequotas.model.ListServicesRequest,
        ListServicesResponse
      ]("listServices", api.listServices)(request.buildAwsValue())
        .map(zio.aws.servicequotas.model.ListServicesResponse.wrap)
        .provideEnvironment(r)
    def getServiceQuota(request: GetServiceQuotaRequest): IO[
      AwsError,
      zio.aws.servicequotas.model.GetServiceQuotaResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaRequest,
      GetServiceQuotaResponse
    ]("getServiceQuota", api.getServiceQuota)(request.buildAwsValue())
      .map(zio.aws.servicequotas.model.GetServiceQuotaResponse.wrap)
      .provideEnvironment(r)
    def associateServiceQuotaTemplate(
        request: AssociateServiceQuotaTemplateRequest
    ): IO[
      AwsError,
      zio.aws.servicequotas.model.AssociateServiceQuotaTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicequotas.model.AssociateServiceQuotaTemplateRequest,
      AssociateServiceQuotaTemplateResponse
    ]("associateServiceQuotaTemplate", api.associateServiceQuotaTemplate)(
      request.buildAwsValue()
    ).map(
      zio.aws.servicequotas.model.AssociateServiceQuotaTemplateResponse.wrap
    ).provideEnvironment(r)
    def listAWSDefaultServiceQuotas(
        request: ListAwsDefaultServiceQuotasRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.servicequotas.model.ServiceQuota.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest,
      ListAwsDefaultServiceQuotasResponse,
      ServiceQuota
    ](
      "listAWSDefaultServiceQuotas",
      api.listAWSDefaultServiceQuotas,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.quotas().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.servicequotas.model.ServiceQuota.wrap(item))
      .provideEnvironment(r)
    def listAWSDefaultServiceQuotasPaginated(
        request: ListAwsDefaultServiceQuotasRequest
    ): IO[
      AwsError,
      zio.aws.servicequotas.model.ListAwsDefaultServiceQuotasResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest,
      ListAwsDefaultServiceQuotasResponse
    ]("listAWSDefaultServiceQuotas", api.listAWSDefaultServiceQuotas)(
      request.buildAwsValue()
    ).map(zio.aws.servicequotas.model.ListAwsDefaultServiceQuotasResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.servicequotas.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicequotas.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.servicequotas.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def getServiceQuotaIncreaseRequestFromTemplate(
        request: GetServiceQuotaIncreaseRequestFromTemplateRequest
    ): IO[
      AwsError,
      zio.aws.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest,
      GetServiceQuotaIncreaseRequestFromTemplateResponse
    ](
      "getServiceQuotaIncreaseRequestFromTemplate",
      api.getServiceQuotaIncreaseRequestFromTemplate
    )(request.buildAwsValue())
      .map(
        zio.aws.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateResponse.wrap
      )
      .provideEnvironment(r)
    def getAssociationForServiceQuotaTemplate(
        request: GetAssociationForServiceQuotaTemplateRequest
    ): IO[
      AwsError,
      zio.aws.servicequotas.model.GetAssociationForServiceQuotaTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicequotas.model.GetAssociationForServiceQuotaTemplateRequest,
      GetAssociationForServiceQuotaTemplateResponse
    ](
      "getAssociationForServiceQuotaTemplate",
      api.getAssociationForServiceQuotaTemplate
    )(request.buildAwsValue())
      .map(
        zio.aws.servicequotas.model.GetAssociationForServiceQuotaTemplateResponse.wrap
      )
      .provideEnvironment(r)
    def getRequestedServiceQuotaChange(
        request: GetRequestedServiceQuotaChangeRequest
    ): IO[
      AwsError,
      zio.aws.servicequotas.model.GetRequestedServiceQuotaChangeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeRequest,
      GetRequestedServiceQuotaChangeResponse
    ]("getRequestedServiceQuotaChange", api.getRequestedServiceQuotaChange)(
      request.buildAwsValue()
    ).map(
      zio.aws.servicequotas.model.GetRequestedServiceQuotaChangeResponse.wrap
    ).provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.servicequotas.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicequotas.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.servicequotas.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.servicequotas.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.servicequotas.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.servicequotas.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listServiceQuotaIncreaseRequestsInTemplate(
        request: ListServiceQuotaIncreaseRequestsInTemplateRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest,
      ListServiceQuotaIncreaseRequestsInTemplateResponse,
      ServiceQuotaIncreaseRequestInTemplate
    ](
      "listServiceQuotaIncreaseRequestsInTemplate",
      api.listServiceQuotaIncreaseRequestsInTemplate,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(
          r.serviceQuotaIncreaseRequestInTemplateList().asScala
        )
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate
          .wrap(item)
      )
      .provideEnvironment(r)
    def listServiceQuotaIncreaseRequestsInTemplatePaginated(
        request: ListServiceQuotaIncreaseRequestsInTemplateRequest
    ): IO[
      AwsError,
      zio.aws.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest,
      ListServiceQuotaIncreaseRequestsInTemplateResponse
    ](
      "listServiceQuotaIncreaseRequestsInTemplate",
      api.listServiceQuotaIncreaseRequestsInTemplate
    )(request.buildAwsValue())
      .map(
        zio.aws.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse.wrap
      )
      .provideEnvironment(r)
    def listRequestedServiceQuotaChangeHistory(
        request: ListRequestedServiceQuotaChangeHistoryRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest,
      ListRequestedServiceQuotaChangeHistoryResponse,
      RequestedServiceQuotaChange
    ](
      "listRequestedServiceQuotaChangeHistory",
      api.listRequestedServiceQuotaChangeHistory,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.requestedQuotas().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.servicequotas.model.RequestedServiceQuotaChange.wrap(item)
      )
      .provideEnvironment(r)
    def listRequestedServiceQuotaChangeHistoryPaginated(
        request: ListRequestedServiceQuotaChangeHistoryRequest
    ): IO[
      AwsError,
      zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest,
      ListRequestedServiceQuotaChangeHistoryResponse
    ](
      "listRequestedServiceQuotaChangeHistory",
      api.listRequestedServiceQuotaChangeHistory
    )(request.buildAwsValue())
      .map(
        zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse.wrap
      )
      .provideEnvironment(r)
    def listRequestedServiceQuotaChangeHistoryByQuota(
        request: ListRequestedServiceQuotaChangeHistoryByQuotaRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest,
      ListRequestedServiceQuotaChangeHistoryByQuotaResponse,
      RequestedServiceQuotaChange
    ](
      "listRequestedServiceQuotaChangeHistoryByQuota",
      api.listRequestedServiceQuotaChangeHistoryByQuota,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.requestedQuotas().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.servicequotas.model.RequestedServiceQuotaChange.wrap(item)
      )
      .provideEnvironment(r)
    def listRequestedServiceQuotaChangeHistoryByQuotaPaginated(
        request: ListRequestedServiceQuotaChangeHistoryByQuotaRequest
    ): IO[
      AwsError,
      zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest,
      ListRequestedServiceQuotaChangeHistoryByQuotaResponse
    ](
      "listRequestedServiceQuotaChangeHistoryByQuota",
      api.listRequestedServiceQuotaChangeHistoryByQuota
    )(request.buildAwsValue())
      .map(
        zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse.wrap
      )
      .provideEnvironment(r)
  }
  def deleteServiceQuotaIncreaseRequestFromTemplate(
      request: DeleteServiceQuotaIncreaseRequestFromTemplateRequest
  ): ZIO[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.deleteServiceQuotaIncreaseRequestFromTemplate(request))
  def listServiceQuotas(request: ListServiceQuotasRequest): ZStream[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.ServiceQuota.ReadOnly
  ] = ZStream.serviceWithStream(_.listServiceQuotas(request))
  def listServiceQuotasPaginated(request: ListServiceQuotasRequest): ZIO[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.ListServiceQuotasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServiceQuotasPaginated(request))
  def disassociateServiceQuotaTemplate(
      request: DisassociateServiceQuotaTemplateRequest
  ): ZIO[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.DisassociateServiceQuotaTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateServiceQuotaTemplate(request))
  def requestServiceQuotaIncrease(
      request: RequestServiceQuotaIncreaseRequest
  ): ZIO[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.RequestServiceQuotaIncreaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.requestServiceQuotaIncrease(request))
  def putServiceQuotaIncreaseRequestIntoTemplate(
      request: PutServiceQuotaIncreaseRequestIntoTemplateRequest
  ): ZIO[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putServiceQuotaIncreaseRequestIntoTemplate(request))
  def getAWSDefaultServiceQuota(request: GetAwsDefaultServiceQuotaRequest): ZIO[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.GetAwsDefaultServiceQuotaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAWSDefaultServiceQuota(request))
  def listServices(
      request: ListServicesRequest
  ): ZStream[zio.aws.servicequotas.ServiceQuotas, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listServices(request))
  def listServicesPaginated(request: ListServicesRequest): ZIO[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.ListServicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServicesPaginated(request))
  def getServiceQuota(request: GetServiceQuotaRequest): ZIO[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.GetServiceQuotaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getServiceQuota(request))
  def associateServiceQuotaTemplate(
      request: AssociateServiceQuotaTemplateRequest
  ): ZIO[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.AssociateServiceQuotaTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateServiceQuotaTemplate(request))
  def listAWSDefaultServiceQuotas(
      request: ListAwsDefaultServiceQuotasRequest
  ): ZStream[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.ServiceQuota.ReadOnly
  ] = ZStream.serviceWithStream(_.listAWSDefaultServiceQuotas(request))
  def listAWSDefaultServiceQuotasPaginated(
      request: ListAwsDefaultServiceQuotasRequest
  ): ZIO[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.ListAwsDefaultServiceQuotasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAWSDefaultServiceQuotasPaginated(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getServiceQuotaIncreaseRequestFromTemplate(
      request: GetServiceQuotaIncreaseRequestFromTemplateRequest
  ): ZIO[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getServiceQuotaIncreaseRequestFromTemplate(request))
  def getAssociationForServiceQuotaTemplate(
      request: GetAssociationForServiceQuotaTemplateRequest
  ): ZIO[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.GetAssociationForServiceQuotaTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAssociationForServiceQuotaTemplate(request))
  def getRequestedServiceQuotaChange(
      request: GetRequestedServiceQuotaChangeRequest
  ): ZIO[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.GetRequestedServiceQuotaChangeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRequestedServiceQuotaChange(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listServiceQuotaIncreaseRequestsInTemplate(
      request: ListServiceQuotaIncreaseRequestsInTemplateRequest
  ): ZStream[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate.ReadOnly
  ] = ZStream.serviceWithStream(
    _.listServiceQuotaIncreaseRequestsInTemplate(request)
  )
  def listServiceQuotaIncreaseRequestsInTemplatePaginated(
      request: ListServiceQuotaIncreaseRequestsInTemplateRequest
  ): ZIO[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listServiceQuotaIncreaseRequestsInTemplatePaginated(request)
  )
  def listRequestedServiceQuotaChangeHistory(
      request: ListRequestedServiceQuotaChangeHistoryRequest
  ): ZStream[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly
  ] =
    ZStream.serviceWithStream(_.listRequestedServiceQuotaChangeHistory(request))
  def listRequestedServiceQuotaChangeHistoryPaginated(
      request: ListRequestedServiceQuotaChangeHistoryRequest
  ): ZIO[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listRequestedServiceQuotaChangeHistoryPaginated(request)
  )
  def listRequestedServiceQuotaChangeHistoryByQuota(
      request: ListRequestedServiceQuotaChangeHistoryByQuotaRequest
  ): ZStream[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.RequestedServiceQuotaChange.ReadOnly
  ] = ZStream.serviceWithStream(
    _.listRequestedServiceQuotaChangeHistoryByQuota(request)
  )
  def listRequestedServiceQuotaChangeHistoryByQuotaPaginated(
      request: ListRequestedServiceQuotaChangeHistoryByQuotaRequest
  ): ZIO[
    zio.aws.servicequotas.ServiceQuotas,
    AwsError,
    zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listRequestedServiceQuotaChangeHistoryByQuotaPaginated(request)
  )
}
