package zio.aws.servicequotas.model
import zio.aws.servicequotas.model.primitives.{ServiceName, ServiceCode}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ServiceInfo(
    serviceCode: Option[ServiceCode] = None,
    serviceName: Option[ServiceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.ServiceInfo = {
    import ServiceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.ServiceInfo
      .builder()
      .optionallyWith(
        serviceCode.map(value => ServiceCode.unwrap(value): java.lang.String)
      )(_.serviceCode)
      .optionallyWith(
        serviceName.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .build()
  }
  def asReadOnly: zio.aws.servicequotas.model.ServiceInfo.ReadOnly =
    zio.aws.servicequotas.model.ServiceInfo.wrap(buildAwsValue())
}
object ServiceInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.ServiceInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicequotas.model.ServiceInfo =
      zio.aws.servicequotas.model.ServiceInfo(
        serviceCode.map(value => value),
        serviceName.map(value => value)
      )
    def serviceCode: Option[ServiceCode]
    def serviceName: Option[ServiceName]
    def getServiceCode: ZIO[Any, AwsError, ServiceCode] =
      AwsError.unwrapOptionField("serviceCode", serviceCode)
    def getServiceName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.ServiceInfo
  ) extends zio.aws.servicequotas.model.ServiceInfo.ReadOnly {
    override val serviceCode: Option[ServiceCode] = scala
      .Option(impl.serviceCode())
      .map(value => zio.aws.servicequotas.model.primitives.ServiceCode(value))
    override val serviceName: Option[ServiceName] = scala
      .Option(impl.serviceName())
      .map(value => zio.aws.servicequotas.model.primitives.ServiceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.ServiceInfo
  ): zio.aws.servicequotas.model.ServiceInfo.ReadOnly = new Wrapper(impl)
}
