package zio.aws.servicequotas.model
import java.lang.Integer
import zio.aws.servicequotas.model.primitives.{
  MaxResults,
  NextToken,
  ServiceCode
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListRequestedServiceQuotaChangeHistoryRequest(
    serviceCode: Option[ServiceCode] = None,
    status: Option[zio.aws.servicequotas.model.RequestStatus] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest = {
    import ListRequestedServiceQuotaChangeHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest
      .builder()
      .optionallyWith(
        serviceCode.map(value => ServiceCode.unwrap(value): java.lang.String)
      )(_.serviceCode)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest.ReadOnly =
    zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest
      .wrap(buildAwsValue())
}
object ListRequestedServiceQuotaChangeHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest =
      zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest(
        serviceCode.map(value => value),
        status.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def serviceCode: Option[ServiceCode]
    def status: Option[zio.aws.servicequotas.model.RequestStatus]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getServiceCode: ZIO[Any, AwsError, ServiceCode] =
      AwsError.unwrapOptionField("serviceCode", serviceCode)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.servicequotas.model.RequestStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest
  ) extends zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest.ReadOnly {
    override val serviceCode: Option[ServiceCode] = scala
      .Option(impl.serviceCode())
      .map(value => zio.aws.servicequotas.model.primitives.ServiceCode(value))
    override val status: Option[zio.aws.servicequotas.model.RequestStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.servicequotas.model.RequestStatus.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.servicequotas.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.servicequotas.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest
  ): zio.aws.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
