package zio.aws.servicequotas.model
import scala.jdk.CollectionConverters._
sealed trait ErrorCode {
  def unwrap: software.amazon.awssdk.services.servicequotas.model.ErrorCode
}
object ErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.servicequotas.model.ErrorCode
  ): zio.aws.servicequotas.model.ErrorCode = value match {
    case software.amazon.awssdk.services.servicequotas.model.ErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicequotas.model.ErrorCode.DEPENDENCY_ACCESS_DENIED_ERROR =>
      val r = DEPENDENCY_ACCESS_DENIED_ERROR
      r
    case software.amazon.awssdk.services.servicequotas.model.ErrorCode.DEPENDENCY_THROTTLING_ERROR =>
      val r = DEPENDENCY_THROTTLING_ERROR
      r
    case software.amazon.awssdk.services.servicequotas.model.ErrorCode.DEPENDENCY_SERVICE_ERROR =>
      val r = DEPENDENCY_SERVICE_ERROR
      r
    case software.amazon.awssdk.services.servicequotas.model.ErrorCode.SERVICE_QUOTA_NOT_AVAILABLE_ERROR =>
      val r = SERVICE_QUOTA_NOT_AVAILABLE_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicequotas.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.ErrorCode =
      software.amazon.awssdk.services.servicequotas.model.ErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object DEPENDENCY_ACCESS_DENIED_ERROR
      extends zio.aws.servicequotas.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.ErrorCode =
      software.amazon.awssdk.services.servicequotas.model.ErrorCode.DEPENDENCY_ACCESS_DENIED_ERROR
  }
  case object DEPENDENCY_THROTTLING_ERROR
      extends zio.aws.servicequotas.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.ErrorCode =
      software.amazon.awssdk.services.servicequotas.model.ErrorCode.DEPENDENCY_THROTTLING_ERROR
  }
  case object DEPENDENCY_SERVICE_ERROR
      extends zio.aws.servicequotas.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.ErrorCode =
      software.amazon.awssdk.services.servicequotas.model.ErrorCode.DEPENDENCY_SERVICE_ERROR
  }
  case object SERVICE_QUOTA_NOT_AVAILABLE_ERROR
      extends zio.aws.servicequotas.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.servicequotas.model.ErrorCode =
      software.amazon.awssdk.services.servicequotas.model.ErrorCode.SERVICE_QUOTA_NOT_AVAILABLE_ERROR
  }
}
