package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.AccountId
import scala.jdk.CollectionConverters._
final case class ShareDetails(
    successfulShares: Optional[Iterable[AccountId]] = Optional.Absent,
    shareErrors: Optional[Iterable[zio.aws.servicecatalog.model.ShareError]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ShareDetails = {
    import ShareDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ShareDetails
      .builder()
      .optionallyWith(
        successfulShares.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.successfulShares)
      .optionallyWith(
        shareErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.shareErrors)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ShareDetails.ReadOnly =
    zio.aws.servicecatalog.model.ShareDetails.wrap(buildAwsValue())
}
object ShareDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ShareDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ShareDetails =
      zio.aws.servicecatalog.model.ShareDetails(
        successfulShares.map(value => value),
        shareErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def successfulShares: Optional[List[AccountId]]
    def shareErrors
        : Optional[List[zio.aws.servicecatalog.model.ShareError.ReadOnly]]
    def getSuccessfulShares: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("successfulShares", successfulShares)
    def getShareErrors: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ShareError.ReadOnly
    ]] = AwsError.unwrapOptionField("shareErrors", shareErrors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ShareDetails
  ) extends zio.aws.servicecatalog.model.ShareDetails.ReadOnly {
    override val successfulShares: Optional[List[AccountId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.successfulShares())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.primitives.AccountId(item)
          }.toList
        )
    override val shareErrors
        : Optional[List[zio.aws.servicecatalog.model.ShareError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shareErrors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.ShareError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ShareDetails
  ): zio.aws.servicecatalog.model.ShareDetails.ReadOnly = new Wrapper(impl)
}
