package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait Replacement {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.Replacement
}
object Replacement {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.Replacement
  ): zio.aws.servicecatalog.model.Replacement = value match {
    case software.amazon.awssdk.services.servicecatalog.model.Replacement.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.Replacement.TRUE =>
      val r = TRUE
      r
    case software.amazon.awssdk.services.servicecatalog.model.Replacement.FALSE =>
      val r = FALSE
      r
    case software.amazon.awssdk.services.servicecatalog.model.Replacement.CONDITIONAL =>
      val r = CONDITIONAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.Replacement {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.Replacement =
      software.amazon.awssdk.services.servicecatalog.model.Replacement.UNKNOWN_TO_SDK_VERSION
  }
  case object TRUE extends zio.aws.servicecatalog.model.Replacement {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.Replacement =
      software.amazon.awssdk.services.servicecatalog.model.Replacement.TRUE
  }
  case object FALSE extends zio.aws.servicecatalog.model.Replacement {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.Replacement =
      software.amazon.awssdk.services.servicecatalog.model.Replacement.FALSE
  }
  case object CONDITIONAL extends zio.aws.servicecatalog.model.Replacement {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.Replacement =
      software.amazon.awssdk.services.servicecatalog.model.Replacement.CONDITIONAL
  }
}
