package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{
  RoleArn,
  RecordType,
  ProvisionedProductType,
  ProvisionedProductName,
  UpdatedTime,
  CreatedTime,
  Id
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class RecordDetail(
    recordId: Optional[Id] = Optional.Absent,
    provisionedProductName: Optional[ProvisionedProductName] = Optional.Absent,
    status: Optional[zio.aws.servicecatalog.model.RecordStatus] =
      Optional.Absent,
    createdTime: Optional[CreatedTime] = Optional.Absent,
    updatedTime: Optional[UpdatedTime] = Optional.Absent,
    provisionedProductType: Optional[ProvisionedProductType] = Optional.Absent,
    recordType: Optional[RecordType] = Optional.Absent,
    provisionedProductId: Optional[Id] = Optional.Absent,
    productId: Optional[Id] = Optional.Absent,
    provisioningArtifactId: Optional[Id] = Optional.Absent,
    pathId: Optional[Id] = Optional.Absent,
    recordErrors: Optional[Iterable[zio.aws.servicecatalog.model.RecordError]] =
      Optional.Absent,
    recordTags: Optional[Iterable[zio.aws.servicecatalog.model.RecordTag]] =
      Optional.Absent,
    launchRoleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.RecordDetail = {
    import RecordDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.RecordDetail
      .builder()
      .optionallyWith(
        recordId.map(value => Id.unwrap(value): java.lang.String)
      )(_.recordId)
      .optionallyWith(
        provisionedProductName.map(value =>
          ProvisionedProductName.unwrap(value): java.lang.String
        )
      )(_.provisionedProductName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        createdTime.map(value => CreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        updatedTime.map(value => UpdatedTime.unwrap(value): Instant)
      )(_.updatedTime)
      .optionallyWith(
        provisionedProductType.map(value =>
          ProvisionedProductType.unwrap(value): java.lang.String
        )
      )(_.provisionedProductType)
      .optionallyWith(
        recordType.map(value => RecordType.unwrap(value): java.lang.String)
      )(_.recordType)
      .optionallyWith(
        provisionedProductId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisionedProductId)
      .optionallyWith(
        productId.map(value => Id.unwrap(value): java.lang.String)
      )(_.productId)
      .optionallyWith(
        provisioningArtifactId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisioningArtifactId)
      .optionallyWith(pathId.map(value => Id.unwrap(value): java.lang.String))(
        _.pathId
      )
      .optionallyWith(
        recordErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recordErrors)
      .optionallyWith(
        recordTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recordTags)
      .optionallyWith(
        launchRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.launchRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.RecordDetail.ReadOnly =
    zio.aws.servicecatalog.model.RecordDetail.wrap(buildAwsValue())
}
object RecordDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.RecordDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.RecordDetail =
      zio.aws.servicecatalog.model.RecordDetail(
        recordId.map(value => value),
        provisionedProductName.map(value => value),
        status.map(value => value),
        createdTime.map(value => value),
        updatedTime.map(value => value),
        provisionedProductType.map(value => value),
        recordType.map(value => value),
        provisionedProductId.map(value => value),
        productId.map(value => value),
        provisioningArtifactId.map(value => value),
        pathId.map(value => value),
        recordErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recordTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        launchRoleArn.map(value => value)
      )
    def recordId: Optional[Id]
    def provisionedProductName: Optional[ProvisionedProductName]
    def status: Optional[zio.aws.servicecatalog.model.RecordStatus]
    def createdTime: Optional[CreatedTime]
    def updatedTime: Optional[UpdatedTime]
    def provisionedProductType: Optional[ProvisionedProductType]
    def recordType: Optional[RecordType]
    def provisionedProductId: Optional[Id]
    def productId: Optional[Id]
    def provisioningArtifactId: Optional[Id]
    def pathId: Optional[Id]
    def recordErrors
        : Optional[List[zio.aws.servicecatalog.model.RecordError.ReadOnly]]
    def recordTags
        : Optional[List[zio.aws.servicecatalog.model.RecordTag.ReadOnly]]
    def launchRoleArn: Optional[RoleArn]
    def getRecordId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("recordId", recordId)
    def getProvisionedProductName: ZIO[Any, AwsError, ProvisionedProductName] =
      AwsError.unwrapOptionField(
        "provisionedProductName",
        provisionedProductName
      )
    def getStatus
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.RecordStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedTime: ZIO[Any, AwsError, CreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getUpdatedTime: ZIO[Any, AwsError, UpdatedTime] =
      AwsError.unwrapOptionField("updatedTime", updatedTime)
    def getProvisionedProductType: ZIO[Any, AwsError, ProvisionedProductType] =
      AwsError.unwrapOptionField(
        "provisionedProductType",
        provisionedProductType
      )
    def getRecordType: ZIO[Any, AwsError, RecordType] =
      AwsError.unwrapOptionField("recordType", recordType)
    def getProvisionedProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("provisionedProductId", provisionedProductId)
    def getProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("productId", productId)
    def getProvisioningArtifactId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("provisioningArtifactId", provisioningArtifactId)
    def getPathId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("pathId", pathId)
    def getRecordErrors: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.RecordError.ReadOnly
    ]] = AwsError.unwrapOptionField("recordErrors", recordErrors)
    def getRecordTags: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.RecordTag.ReadOnly
    ]] = AwsError.unwrapOptionField("recordTags", recordTags)
    def getLaunchRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("launchRoleArn", launchRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.RecordDetail
  ) extends zio.aws.servicecatalog.model.RecordDetail.ReadOnly {
    override val recordId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.recordId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisionedProductName: Optional[ProvisionedProductName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedProductName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.ProvisionedProductName(value)
        )
    override val status: Optional[zio.aws.servicecatalog.model.RecordStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.servicecatalog.model.RecordStatus.wrap(value))
    override val createdTime: Optional[CreatedTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.servicecatalog.model.primitives.CreatedTime(value))
    override val updatedTime: Optional[UpdatedTime] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedTime())
      .map(value => zio.aws.servicecatalog.model.primitives.UpdatedTime(value))
    override val provisionedProductType: Optional[ProvisionedProductType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedProductType())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.ProvisionedProductType(value)
        )
    override val recordType: Optional[RecordType] = zio.aws.core.internal
      .optionalFromNullable(impl.recordType())
      .map(value => zio.aws.servicecatalog.model.primitives.RecordType(value))
    override val provisionedProductId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedProductId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val productId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.productId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisioningArtifactId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningArtifactId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val pathId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.pathId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val recordErrors
        : Optional[List[zio.aws.servicecatalog.model.RecordError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordErrors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.RecordError.wrap(item)
          }.toList
        )
    override val recordTags
        : Optional[List[zio.aws.servicecatalog.model.RecordTag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.RecordTag.wrap(item)
          }.toList
        )
    override val launchRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.launchRoleArn())
      .map(value => zio.aws.servicecatalog.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.RecordDetail
  ): zio.aws.servicecatalog.model.RecordDetail.ReadOnly = new Wrapper(impl)
}
