package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{
  StackSetMaxConcurrencyCount,
  AccountId,
  StackSetFailureToleranceCount,
  Region,
  StackSetFailureTolerancePercentage,
  StackSetMaxConcurrencyPercentage
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ProvisioningPreferences(
    stackSetAccounts: Optional[Iterable[AccountId]] = Optional.Absent,
    stackSetRegions: Optional[Iterable[Region]] = Optional.Absent,
    stackSetFailureToleranceCount: Optional[StackSetFailureToleranceCount] =
      Optional.Absent,
    stackSetFailureTolerancePercentage: Optional[
      StackSetFailureTolerancePercentage
    ] = Optional.Absent,
    stackSetMaxConcurrencyCount: Optional[StackSetMaxConcurrencyCount] =
      Optional.Absent,
    stackSetMaxConcurrencyPercentage: Optional[
      StackSetMaxConcurrencyPercentage
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisioningPreferences = {
    import ProvisioningPreferences.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningPreferences
      .builder()
      .optionallyWith(
        stackSetAccounts.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stackSetAccounts)
      .optionallyWith(
        stackSetRegions.map(value =>
          value.map { item =>
            Region.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stackSetRegions)
      .optionallyWith(
        stackSetFailureToleranceCount.map(value =>
          StackSetFailureToleranceCount.unwrap(value): Integer
        )
      )(_.stackSetFailureToleranceCount)
      .optionallyWith(
        stackSetFailureTolerancePercentage.map(value =>
          StackSetFailureTolerancePercentage.unwrap(value): Integer
        )
      )(_.stackSetFailureTolerancePercentage)
      .optionallyWith(
        stackSetMaxConcurrencyCount.map(value =>
          StackSetMaxConcurrencyCount.unwrap(value): Integer
        )
      )(_.stackSetMaxConcurrencyCount)
      .optionallyWith(
        stackSetMaxConcurrencyPercentage.map(value =>
          StackSetMaxConcurrencyPercentage.unwrap(value): Integer
        )
      )(_.stackSetMaxConcurrencyPercentage)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisioningPreferences.ReadOnly =
    zio.aws.servicecatalog.model.ProvisioningPreferences.wrap(buildAwsValue())
}
object ProvisioningPreferences {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningPreferences
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisioningPreferences =
      zio.aws.servicecatalog.model.ProvisioningPreferences(
        stackSetAccounts.map(value => value),
        stackSetRegions.map(value => value),
        stackSetFailureToleranceCount.map(value => value),
        stackSetFailureTolerancePercentage.map(value => value),
        stackSetMaxConcurrencyCount.map(value => value),
        stackSetMaxConcurrencyPercentage.map(value => value)
      )
    def stackSetAccounts: Optional[List[AccountId]]
    def stackSetRegions: Optional[List[Region]]
    def stackSetFailureToleranceCount: Optional[StackSetFailureToleranceCount]
    def stackSetFailureTolerancePercentage
        : Optional[StackSetFailureTolerancePercentage]
    def stackSetMaxConcurrencyCount: Optional[StackSetMaxConcurrencyCount]
    def stackSetMaxConcurrencyPercentage
        : Optional[StackSetMaxConcurrencyPercentage]
    def getStackSetAccounts: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("stackSetAccounts", stackSetAccounts)
    def getStackSetRegions: ZIO[Any, AwsError, List[Region]] =
      AwsError.unwrapOptionField("stackSetRegions", stackSetRegions)
    def getStackSetFailureToleranceCount
        : ZIO[Any, AwsError, StackSetFailureToleranceCount] =
      AwsError.unwrapOptionField(
        "stackSetFailureToleranceCount",
        stackSetFailureToleranceCount
      )
    def getStackSetFailureTolerancePercentage
        : ZIO[Any, AwsError, StackSetFailureTolerancePercentage] =
      AwsError.unwrapOptionField(
        "stackSetFailureTolerancePercentage",
        stackSetFailureTolerancePercentage
      )
    def getStackSetMaxConcurrencyCount
        : ZIO[Any, AwsError, StackSetMaxConcurrencyCount] =
      AwsError.unwrapOptionField(
        "stackSetMaxConcurrencyCount",
        stackSetMaxConcurrencyCount
      )
    def getStackSetMaxConcurrencyPercentage
        : ZIO[Any, AwsError, StackSetMaxConcurrencyPercentage] =
      AwsError.unwrapOptionField(
        "stackSetMaxConcurrencyPercentage",
        stackSetMaxConcurrencyPercentage
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningPreferences
  ) extends zio.aws.servicecatalog.model.ProvisioningPreferences.ReadOnly {
    override val stackSetAccounts: Optional[List[AccountId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stackSetAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.primitives.AccountId(item)
          }.toList
        )
    override val stackSetRegions: Optional[List[Region]] = zio.aws.core.internal
      .optionalFromNullable(impl.stackSetRegions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.primitives.Region(item)
        }.toList
      )
    override val stackSetFailureToleranceCount
        : Optional[StackSetFailureToleranceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.stackSetFailureToleranceCount())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .StackSetFailureToleranceCount(value)
      )
    override val stackSetFailureTolerancePercentage
        : Optional[StackSetFailureTolerancePercentage] = zio.aws.core.internal
      .optionalFromNullable(impl.stackSetFailureTolerancePercentage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .StackSetFailureTolerancePercentage(value)
      )
    override val stackSetMaxConcurrencyCount
        : Optional[StackSetMaxConcurrencyCount] = zio.aws.core.internal
      .optionalFromNullable(impl.stackSetMaxConcurrencyCount())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .StackSetMaxConcurrencyCount(value)
      )
    override val stackSetMaxConcurrencyPercentage
        : Optional[StackSetMaxConcurrencyPercentage] = zio.aws.core.internal
      .optionalFromNullable(impl.stackSetMaxConcurrencyPercentage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .StackSetMaxConcurrencyPercentage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningPreferences
  ): zio.aws.servicecatalog.model.ProvisioningPreferences.ReadOnly =
    new Wrapper(impl)
}
