package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{
  ProvisioningArtifactCreatedTime,
  ProvisioningArtifactDescription,
  ProvisioningArtifactName,
  Id
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ProvisioningArtifact(
    id: Optional[Id] = Optional.Absent,
    name: Optional[ProvisioningArtifactName] = Optional.Absent,
    description: Optional[ProvisioningArtifactDescription] = Optional.Absent,
    createdTime: Optional[ProvisioningArtifactCreatedTime] = Optional.Absent,
    guidance: Optional[
      zio.aws.servicecatalog.model.ProvisioningArtifactGuidance
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifact = {
    import ProvisioningArtifact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifact
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        name.map(value =>
          ProvisioningArtifactName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ProvisioningArtifactDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        createdTime.map(value =>
          ProvisioningArtifactCreatedTime.unwrap(value): Instant
        )
      )(_.createdTime)
      .optionallyWith(guidance.map(value => value.unwrap))(_.guidance)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly =
    zio.aws.servicecatalog.model.ProvisioningArtifact.wrap(buildAwsValue())
}
object ProvisioningArtifact {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifact
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisioningArtifact =
      zio.aws.servicecatalog.model.ProvisioningArtifact(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        createdTime.map(value => value),
        guidance.map(value => value)
      )
    def id: Optional[Id]
    def name: Optional[ProvisioningArtifactName]
    def description: Optional[ProvisioningArtifactDescription]
    def createdTime: Optional[ProvisioningArtifactCreatedTime]
    def guidance
        : Optional[zio.aws.servicecatalog.model.ProvisioningArtifactGuidance]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ProvisioningArtifactName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ProvisioningArtifactDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedTime: ZIO[Any, AwsError, ProvisioningArtifactCreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getGuidance: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisioningArtifactGuidance
    ] = AwsError.unwrapOptionField("guidance", guidance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifact
  ) extends zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly {
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val name: Optional[ProvisioningArtifactName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisioningArtifactName(value)
        )
    override val description: Optional[ProvisioningArtifactDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisioningArtifactDescription(value)
        )
    override val createdTime: Optional[ProvisioningArtifactCreatedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTime())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisioningArtifactCreatedTime(value)
        )
    override val guidance
        : Optional[zio.aws.servicecatalog.model.ProvisioningArtifactGuidance] =
      zio.aws.core.internal
        .optionalFromNullable(impl.guidance())
        .map(value =>
          zio.aws.servicecatalog.model.ProvisioningArtifactGuidance.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifact
  ): zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly = new Wrapper(
    impl
  )
}
