package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait ProductType {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.ProductType
}
object ProductType {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.ProductType
  ): zio.aws.servicecatalog.model.ProductType = value match {
    case software.amazon.awssdk.services.servicecatalog.model.ProductType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.ProductType.CLOUD_FORMATION_TEMPLATE =>
      val r = CLOUD_FORMATION_TEMPLATE
      r
    case software.amazon.awssdk.services.servicecatalog.model.ProductType.MARKETPLACE =>
      val r = MARKETPLACE
      r
    case software.amazon.awssdk.services.servicecatalog.model.ProductType.TERRAFORM_OPEN_SOURCE =>
      val r = TERRAFORM_OPEN_SOURCE
      r
    case software.amazon.awssdk.services.servicecatalog.model.ProductType.TERRAFORM_CLOUD =>
      val r = TERRAFORM_CLOUD
      r
    case software.amazon.awssdk.services.servicecatalog.model.ProductType.EXTERNAL =>
      val r = EXTERNAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.ProductType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProductType =
      software.amazon.awssdk.services.servicecatalog.model.ProductType.UNKNOWN_TO_SDK_VERSION
  }
  case object CLOUD_FORMATION_TEMPLATE
      extends zio.aws.servicecatalog.model.ProductType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProductType =
      software.amazon.awssdk.services.servicecatalog.model.ProductType.CLOUD_FORMATION_TEMPLATE
  }
  case object MARKETPLACE extends zio.aws.servicecatalog.model.ProductType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProductType =
      software.amazon.awssdk.services.servicecatalog.model.ProductType.MARKETPLACE
  }
  case object TERRAFORM_OPEN_SOURCE
      extends zio.aws.servicecatalog.model.ProductType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProductType =
      software.amazon.awssdk.services.servicecatalog.model.ProductType.TERRAFORM_OPEN_SOURCE
  }
  case object TERRAFORM_CLOUD extends zio.aws.servicecatalog.model.ProductType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProductType =
      software.amazon.awssdk.services.servicecatalog.model.ProductType.TERRAFORM_CLOUD
  }
  case object EXTERNAL extends zio.aws.servicecatalog.model.ProductType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProductType =
      software.amazon.awssdk.services.servicecatalog.model.ProductType.EXTERNAL
  }
}
