package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  ServiceActionAssociationErrorMessage,
  Id
}
import scala.jdk.CollectionConverters._
final case class FailedServiceActionAssociation(
    serviceActionId: Optional[Id] = Optional.Absent,
    productId: Optional[Id] = Optional.Absent,
    provisioningArtifactId: Optional[Id] = Optional.Absent,
    errorCode: Optional[
      zio.aws.servicecatalog.model.ServiceActionAssociationErrorCode
    ] = Optional.Absent,
    errorMessage: Optional[ServiceActionAssociationErrorMessage] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.FailedServiceActionAssociation = {
    import FailedServiceActionAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.FailedServiceActionAssociation
      .builder()
      .optionallyWith(
        serviceActionId.map(value => Id.unwrap(value): java.lang.String)
      )(_.serviceActionId)
      .optionallyWith(
        productId.map(value => Id.unwrap(value): java.lang.String)
      )(_.productId)
      .optionallyWith(
        provisioningArtifactId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisioningArtifactId)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(
        errorMessage.map(value =>
          ServiceActionAssociationErrorMessage.unwrap(value): java.lang.String
        )
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.FailedServiceActionAssociation.ReadOnly =
    zio.aws.servicecatalog.model.FailedServiceActionAssociation
      .wrap(buildAwsValue())
}
object FailedServiceActionAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.FailedServiceActionAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.FailedServiceActionAssociation =
      zio.aws.servicecatalog.model.FailedServiceActionAssociation(
        serviceActionId.map(value => value),
        productId.map(value => value),
        provisioningArtifactId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def serviceActionId: Optional[Id]
    def productId: Optional[Id]
    def provisioningArtifactId: Optional[Id]
    def errorCode: Optional[
      zio.aws.servicecatalog.model.ServiceActionAssociationErrorCode
    ]
    def errorMessage: Optional[ServiceActionAssociationErrorMessage]
    def getServiceActionId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("serviceActionId", serviceActionId)
    def getProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("productId", productId)
    def getProvisioningArtifactId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("provisioningArtifactId", provisioningArtifactId)
    def getErrorCode: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ServiceActionAssociationErrorCode
    ] = AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage
        : ZIO[Any, AwsError, ServiceActionAssociationErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.FailedServiceActionAssociation
  ) extends zio.aws.servicecatalog.model.FailedServiceActionAssociation.ReadOnly {
    override val serviceActionId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceActionId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val productId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.productId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisioningArtifactId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningArtifactId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val errorCode: Optional[
      zio.aws.servicecatalog.model.ServiceActionAssociationErrorCode
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value =>
        zio.aws.servicecatalog.model.ServiceActionAssociationErrorCode
          .wrap(value)
      )
    override val errorMessage: Optional[ServiceActionAssociationErrorMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorMessage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ServiceActionAssociationErrorMessage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.FailedServiceActionAssociation
  ): zio.aws.servicecatalog.model.FailedServiceActionAssociation.ReadOnly =
    new Wrapper(impl)
}
