package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait EngineWorkflowStatus {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.EngineWorkflowStatus
}
object EngineWorkflowStatus {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.EngineWorkflowStatus
  ): zio.aws.servicecatalog.model.EngineWorkflowStatus = value match {
    case software.amazon.awssdk.services.servicecatalog.model.EngineWorkflowStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.EngineWorkflowStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.servicecatalog.model.EngineWorkflowStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.EngineWorkflowStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.EngineWorkflowStatus =
      software.amazon.awssdk.services.servicecatalog.model.EngineWorkflowStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCEEDED
      extends zio.aws.servicecatalog.model.EngineWorkflowStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.EngineWorkflowStatus =
      software.amazon.awssdk.services.servicecatalog.model.EngineWorkflowStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.servicecatalog.model.EngineWorkflowStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.EngineWorkflowStatus =
      software.amazon.awssdk.services.servicecatalog.model.EngineWorkflowStatus.FAILED
  }
}
