package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EngineWorkflowResourceIdentifier(
    uniqueTag: Optional[
      zio.aws.servicecatalog.model.UniqueTagResourceIdentifier
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.EngineWorkflowResourceIdentifier = {
    import EngineWorkflowResourceIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.EngineWorkflowResourceIdentifier
      .builder()
      .optionallyWith(uniqueTag.map(value => value.buildAwsValue()))(
        _.uniqueTag
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.EngineWorkflowResourceIdentifier.ReadOnly =
    zio.aws.servicecatalog.model.EngineWorkflowResourceIdentifier
      .wrap(buildAwsValue())
}
object EngineWorkflowResourceIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.EngineWorkflowResourceIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.EngineWorkflowResourceIdentifier =
      zio.aws.servicecatalog.model.EngineWorkflowResourceIdentifier(
        uniqueTag.map(value => value.asEditable)
      )
    def uniqueTag: Optional[
      zio.aws.servicecatalog.model.UniqueTagResourceIdentifier.ReadOnly
    ]
    def getUniqueTag: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.UniqueTagResourceIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField("uniqueTag", uniqueTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.EngineWorkflowResourceIdentifier
  ) extends zio.aws.servicecatalog.model.EngineWorkflowResourceIdentifier.ReadOnly {
    override val uniqueTag: Optional[
      zio.aws.servicecatalog.model.UniqueTagResourceIdentifier.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.uniqueTag())
      .map(value =>
        zio.aws.servicecatalog.model.UniqueTagResourceIdentifier.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.EngineWorkflowResourceIdentifier
  ): zio.aws.servicecatalog.model.EngineWorkflowResourceIdentifier.ReadOnly =
    new Wrapper(impl)
}
