package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{
  PageToken,
  PageSize,
  Id,
  AcceptLanguage
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeProvisionedProductPlanRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    planId: Id,
    pageSize: Optional[PageSize] = Optional.Absent,
    pageToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductPlanRequest = {
    import DescribeProvisionedProductPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductPlanRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .planId(Id.unwrap(planId): java.lang.String)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeProvisionedProductPlanRequest.ReadOnly =
    zio.aws.servicecatalog.model.DescribeProvisionedProductPlanRequest
      .wrap(buildAwsValue())
}
object DescribeProvisionedProductPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribeProvisionedProductPlanRequest =
      zio.aws.servicecatalog.model.DescribeProvisionedProductPlanRequest(
        acceptLanguage.map(value => value),
        planId,
        pageSize.map(value => value),
        pageToken.map(value => value)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def planId: Id
    def pageSize: Optional[PageSize]
    def pageToken: Optional[PageToken]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getPlanId: ZIO[Any, Nothing, Id] = ZIO.succeed(planId)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductPlanRequest
  ) extends zio.aws.servicecatalog.model.DescribeProvisionedProductPlanRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val planId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.planId())
    override val pageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => zio.aws.servicecatalog.model.primitives.PageSize(value))
    override val pageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductPlanRequest
  ): zio.aws.servicecatalog.model.DescribeProvisionedProductPlanRequest.ReadOnly =
    new Wrapper(impl)
}
