package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{Id, AcceptLanguage}
import scala.jdk.CollectionConverters._
final case class DescribePortfolioRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    id: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioRequest = {
    import DescribePortfolioRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .id(Id.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribePortfolioRequest.ReadOnly =
    zio.aws.servicecatalog.model.DescribePortfolioRequest.wrap(buildAwsValue())
}
object DescribePortfolioRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.DescribePortfolioRequest =
      zio.aws.servicecatalog.model
        .DescribePortfolioRequest(acceptLanguage.map(value => value), id)
    def acceptLanguage: Optional[AcceptLanguage]
    def id: Id
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioRequest
  ) extends zio.aws.servicecatalog.model.DescribePortfolioRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val id: Id = zio.aws.servicecatalog.model.primitives.Id(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioRequest
  ): zio.aws.servicecatalog.model.DescribePortfolioRequest.ReadOnly =
    new Wrapper(impl)
}
