package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ServiceActionDescription,
  ServiceActionDefinitionValue,
  IdempotencyToken,
  ServiceActionName
}
import scala.jdk.CollectionConverters._
final case class CreateServiceActionRequest(
    name: ServiceActionName,
    definitionType: zio.aws.servicecatalog.model.ServiceActionDefinitionType,
    definition: Map[
      zio.aws.servicecatalog.model.ServiceActionDefinitionKey,
      ServiceActionDefinitionValue
    ],
    description: Optional[ServiceActionDescription] = Optional.Absent,
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    idempotencyToken: IdempotencyToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CreateServiceActionRequest = {
    import CreateServiceActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CreateServiceActionRequest
      .builder()
      .name(ServiceActionName.unwrap(name): java.lang.String)
      .definitionType(definitionType.unwrap)
      .definitionWithStrings(
        definition
          .map({ case (key, value) =>
            key.unwrap.toString -> (ServiceActionDefinitionValue.unwrap(
              value
            ): java.lang.String)
          })
          .asJava
      )
      .optionallyWith(
        description.map(value =>
          ServiceActionDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .idempotencyToken(
        IdempotencyToken.unwrap(idempotencyToken): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.CreateServiceActionRequest.ReadOnly =
    zio.aws.servicecatalog.model.CreateServiceActionRequest
      .wrap(buildAwsValue())
}
object CreateServiceActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CreateServiceActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.CreateServiceActionRequest =
      zio.aws.servicecatalog.model.CreateServiceActionRequest(
        name,
        definitionType,
        definition,
        description.map(value => value),
        acceptLanguage.map(value => value),
        idempotencyToken
      )
    def name: ServiceActionName
    def definitionType: zio.aws.servicecatalog.model.ServiceActionDefinitionType
    def definition: Map[
      zio.aws.servicecatalog.model.ServiceActionDefinitionKey,
      ServiceActionDefinitionValue
    ]
    def description: Optional[ServiceActionDescription]
    def acceptLanguage: Optional[AcceptLanguage]
    def idempotencyToken: IdempotencyToken
    def getName: ZIO[Any, Nothing, ServiceActionName] = ZIO.succeed(name)
    def getDefinitionType: ZIO[
      Any,
      Nothing,
      zio.aws.servicecatalog.model.ServiceActionDefinitionType
    ] = ZIO.succeed(definitionType)
    def getDefinition: ZIO[Any, Nothing, Map[
      zio.aws.servicecatalog.model.ServiceActionDefinitionKey,
      ServiceActionDefinitionValue
    ]] = ZIO.succeed(definition)
    def getDescription: ZIO[Any, AwsError, ServiceActionDescription] =
      AwsError.unwrapOptionField("description", description)
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getIdempotencyToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateServiceActionRequest
  ) extends zio.aws.servicecatalog.model.CreateServiceActionRequest.ReadOnly {
    override val name: ServiceActionName =
      zio.aws.servicecatalog.model.primitives.ServiceActionName(impl.name())
    override val definitionType
        : zio.aws.servicecatalog.model.ServiceActionDefinitionType =
      zio.aws.servicecatalog.model.ServiceActionDefinitionType
        .wrap(impl.definitionType())
    override val definition: Map[
      zio.aws.servicecatalog.model.ServiceActionDefinitionKey,
      ServiceActionDefinitionValue
    ] = impl
      .definition()
      .asScala
      .map({ case (key, value) =>
        zio.aws.servicecatalog.model.ServiceActionDefinitionKey
          .wrap(key) -> zio.aws.servicecatalog.model.primitives
          .ServiceActionDefinitionValue(value)
      })
      .toMap
    override val description: Optional[ServiceActionDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ServiceActionDescription(value)
        )
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val idempotencyToken: IdempotencyToken =
      zio.aws.servicecatalog.model.primitives
        .IdempotencyToken(impl.idempotencyToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateServiceActionRequest
  ): zio.aws.servicecatalog.model.CreateServiceActionRequest.ReadOnly =
    new Wrapper(impl)
}
