package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ProvisionedProductPlanName,
  NotificationArn,
  ProvisionedProductName,
  IdempotencyToken,
  Id
}
import scala.jdk.CollectionConverters._
final case class CreateProvisionedProductPlanRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    planName: ProvisionedProductPlanName,
    planType: zio.aws.servicecatalog.model.ProvisionedProductPlanType,
    notificationArns: Optional[Iterable[NotificationArn]] = Optional.Absent,
    pathId: Optional[Id] = Optional.Absent,
    productId: Id,
    provisionedProductName: ProvisionedProductName,
    provisioningArtifactId: Id,
    provisioningParameters: Optional[
      Iterable[zio.aws.servicecatalog.model.UpdateProvisioningParameter]
    ] = Optional.Absent,
    idempotencyToken: IdempotencyToken,
    tags: Optional[Iterable[zio.aws.servicecatalog.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanRequest = {
    import CreateProvisionedProductPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .planName(ProvisionedProductPlanName.unwrap(planName): java.lang.String)
      .planType(planType.unwrap)
      .optionallyWith(
        notificationArns.map(value =>
          value.map { item =>
            NotificationArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.notificationArns)
      .optionallyWith(pathId.map(value => Id.unwrap(value): java.lang.String))(
        _.pathId
      )
      .productId(Id.unwrap(productId): java.lang.String)
      .provisionedProductName(
        ProvisionedProductName.unwrap(provisionedProductName): java.lang.String
      )
      .provisioningArtifactId(
        Id.unwrap(provisioningArtifactId): java.lang.String
      )
      .optionallyWith(
        provisioningParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisioningParameters)
      .idempotencyToken(
        IdempotencyToken.unwrap(idempotencyToken): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.CreateProvisionedProductPlanRequest.ReadOnly =
    zio.aws.servicecatalog.model.CreateProvisionedProductPlanRequest
      .wrap(buildAwsValue())
}
object CreateProvisionedProductPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.CreateProvisionedProductPlanRequest =
      zio.aws.servicecatalog.model.CreateProvisionedProductPlanRequest(
        acceptLanguage.map(value => value),
        planName,
        planType,
        notificationArns.map(value => value),
        pathId.map(value => value),
        productId,
        provisionedProductName,
        provisioningArtifactId,
        provisioningParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        idempotencyToken,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def planName: ProvisionedProductPlanName
    def planType: zio.aws.servicecatalog.model.ProvisionedProductPlanType
    def notificationArns: Optional[List[NotificationArn]]
    def pathId: Optional[Id]
    def productId: Id
    def provisionedProductName: ProvisionedProductName
    def provisioningArtifactId: Id
    def provisioningParameters: Optional[
      List[zio.aws.servicecatalog.model.UpdateProvisioningParameter.ReadOnly]
    ]
    def idempotencyToken: IdempotencyToken
    def tags: Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getPlanName: ZIO[Any, Nothing, ProvisionedProductPlanName] =
      ZIO.succeed(planName)
    def getPlanType: ZIO[
      Any,
      Nothing,
      zio.aws.servicecatalog.model.ProvisionedProductPlanType
    ] = ZIO.succeed(planType)
    def getNotificationArns: ZIO[Any, AwsError, List[NotificationArn]] =
      AwsError.unwrapOptionField("notificationArns", notificationArns)
    def getPathId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("pathId", pathId)
    def getProductId: ZIO[Any, Nothing, Id] = ZIO.succeed(productId)
    def getProvisionedProductName: ZIO[Any, Nothing, ProvisionedProductName] =
      ZIO.succeed(provisionedProductName)
    def getProvisioningArtifactId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(provisioningArtifactId)
    def getProvisioningParameters: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.UpdateProvisioningParameter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "provisioningParameters",
      provisioningParameters
    )
    def getIdempotencyToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(idempotencyToken)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanRequest
  ) extends zio.aws.servicecatalog.model.CreateProvisionedProductPlanRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val planName: ProvisionedProductPlanName =
      zio.aws.servicecatalog.model.primitives
        .ProvisionedProductPlanName(impl.planName())
    override val planType
        : zio.aws.servicecatalog.model.ProvisionedProductPlanType =
      zio.aws.servicecatalog.model.ProvisionedProductPlanType
        .wrap(impl.planType())
    override val notificationArns: Optional[List[NotificationArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.primitives.NotificationArn(item)
          }.toList
        )
    override val pathId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.pathId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val productId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.productId())
    override val provisionedProductName: ProvisionedProductName =
      zio.aws.servicecatalog.model.primitives
        .ProvisionedProductName(impl.provisionedProductName())
    override val provisioningArtifactId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.provisioningArtifactId())
    override val provisioningParameters: Optional[
      List[zio.aws.servicecatalog.model.UpdateProvisioningParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.UpdateProvisioningParameter.wrap(item)
        }.toList
      )
    override val idempotencyToken: IdempotencyToken =
      zio.aws.servicecatalog.model.primitives
        .IdempotencyToken(impl.idempotencyToken())
    override val tags
        : Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanRequest
  ): zio.aws.servicecatalog.model.CreateProvisionedProductPlanRequest.ReadOnly =
    new Wrapper(impl)
}
