package zio.aws.servicecatalog
import zio.aws.servicecatalog.model.ListProvisioningArtifactsResponse.ReadOnly
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.servicecatalog.model.{
  DescribePortfolioSharesRequest,
  ListServiceActionsRequest,
  CreatePortfolioShareRequest,
  UpdateConstraintRequest,
  ListPrincipalsForPortfolioRequest,
  EnableAwsOrganizationsAccessRequest,
  DescribeProductAsAdminRequest,
  DeleteTagOptionRequest,
  AssociateServiceActionWithProvisioningArtifactRequest,
  SearchProductsAsAdminRequest,
  NotifyTerminateProvisionedProductEngineWorkflowResultRequest,
  ExecuteProvisionedProductPlanRequest,
  ImportAsProvisionedProductRequest,
  AssociateBudgetWithResourceRequest,
  BatchAssociateServiceActionWithProvisioningArtifactRequest,
  AcceptPortfolioShareRequest,
  AssociateTagOptionWithResourceRequest,
  UpdateProvisionedProductPropertiesRequest,
  ListPortfoliosRequest,
  SearchProductsRequest,
  UpdateTagOptionRequest,
  ListOrganizationPortfolioAccessRequest,
  UpdateProductRequest,
  DescribeRecordRequest,
  UpdatePortfolioShareRequest,
  DescribeProvisionedProductRequest,
  DisassociatePrincipalFromPortfolioRequest,
  DisassociateProductFromPortfolioRequest,
  DescribeProvisionedProductPlanRequest,
  ListBudgetsForResourceRequest,
  DescribeProductRequest,
  CreateProvisionedProductPlanRequest,
  ListStackInstancesForProvisionedProductRequest,
  SearchProvisionedProductsRequest,
  ListLaunchPathsRequest,
  ScanProvisionedProductsRequest,
  DeleteConstraintRequest,
  AssociatePrincipalWithPortfolioRequest,
  CreatePortfolioRequest,
  DeleteServiceActionRequest,
  ListServiceActionsForProvisioningArtifactRequest,
  DescribePortfolioRequest,
  DeleteProductRequest,
  ListConstraintsForPortfolioRequest,
  DeleteProvisionedProductPlanRequest,
  DescribeTagOptionRequest,
  GetAwsOrganizationsAccessStatusRequest,
  NotifyUpdateProvisionedProductEngineWorkflowResultRequest,
  ListProvisionedProductPlansRequest,
  CreateTagOptionRequest,
  DescribeServiceActionRequest,
  DescribeServiceActionExecutionParametersRequest,
  DisassociateBudgetFromResourceRequest,
  AssociateProductWithPortfolioRequest,
  DescribePortfolioShareStatusRequest,
  UpdatePortfolioRequest,
  UpdateServiceActionRequest,
  DescribeCopyProductStatusRequest,
  ListTagOptionsRequest,
  CreateConstraintRequest,
  CreateProvisioningArtifactRequest,
  CreateServiceActionRequest,
  ListAcceptedPortfolioSharesRequest,
  ProvisionProductRequest,
  DescribeProductViewRequest,
  TerminateProvisionedProductRequest,
  UpdateProvisionedProductRequest,
  GetProvisionedProductOutputsRequest,
  DisassociateServiceActionFromProvisioningArtifactRequest,
  ListPortfoliosForProductRequest,
  DescribeProvisioningArtifactRequest,
  DeletePortfolioRequest,
  BatchDisassociateServiceActionFromProvisioningArtifactRequest,
  DisableAwsOrganizationsAccessRequest,
  CreateProductRequest,
  ListPortfolioAccessRequest,
  DisassociateTagOptionFromResourceRequest,
  UpdateProvisioningArtifactRequest,
  ListProvisioningArtifactsForServiceActionRequest,
  DescribeConstraintRequest,
  CopyProductRequest,
  ListResourcesForTagOptionRequest,
  ExecuteProvisionedProductServiceActionRequest,
  DeletePortfolioShareRequest,
  DeleteProvisioningArtifactRequest,
  ListRecordHistoryRequest,
  DescribeProvisioningParametersRequest,
  NotifyProvisionProductEngineWorkflowResultRequest,
  RejectPortfolioShareRequest,
  ListProvisioningArtifactsRequest
}
object ServiceCatalogMock extends Mock[ServiceCatalog] {
  object ListResourcesForTagOption
      extends Effect[
        ListResourcesForTagOptionRequest,
        AwsError,
        zio.aws.servicecatalog.model.ListResourcesForTagOptionResponse.ReadOnly
      ]
  object UpdateTagOption
      extends Effect[
        UpdateTagOptionRequest,
        AwsError,
        zio.aws.servicecatalog.model.UpdateTagOptionResponse.ReadOnly
      ]
  object DisassociateTagOptionFromResource
      extends Effect[
        DisassociateTagOptionFromResourceRequest,
        AwsError,
        zio.aws.servicecatalog.model.DisassociateTagOptionFromResourceResponse.ReadOnly
      ]
  object ListProvisioningArtifacts
      extends Effect[ListProvisioningArtifactsRequest, AwsError, ReadOnly]
  object AssociatePrincipalWithPortfolio
      extends Effect[
        AssociatePrincipalWithPortfolioRequest,
        AwsError,
        zio.aws.servicecatalog.model.AssociatePrincipalWithPortfolioResponse.ReadOnly
      ]
  object ListProvisioningArtifactsForServiceAction
      extends Effect[
        ListProvisioningArtifactsForServiceActionRequest,
        AwsError,
        zio.aws.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse.ReadOnly
      ]
  object ExecuteProvisionedProductServiceAction
      extends Effect[
        ExecuteProvisionedProductServiceActionRequest,
        AwsError,
        zio.aws.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse.ReadOnly
      ]
  object AssociateProductWithPortfolio
      extends Effect[
        AssociateProductWithPortfolioRequest,
        AwsError,
        zio.aws.servicecatalog.model.AssociateProductWithPortfolioResponse.ReadOnly
      ]
  object DescribeServiceAction
      extends Effect[
        DescribeServiceActionRequest,
        AwsError,
        zio.aws.servicecatalog.model.DescribeServiceActionResponse.ReadOnly
      ]
  object UpdateProvisionedProductProperties
      extends Effect[
        UpdateProvisionedProductPropertiesRequest,
        AwsError,
        zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesResponse.ReadOnly
      ]
  object CreateConstraint
      extends Effect[
        CreateConstraintRequest,
        AwsError,
        zio.aws.servicecatalog.model.CreateConstraintResponse.ReadOnly
      ]
  object TerminateProvisionedProduct
      extends Effect[
        TerminateProvisionedProductRequest,
        AwsError,
        zio.aws.servicecatalog.model.TerminateProvisionedProductResponse.ReadOnly
      ]
  object ListServiceActions
      extends Effect[
        ListServiceActionsRequest,
        AwsError,
        zio.aws.servicecatalog.model.ListServiceActionsResponse.ReadOnly
      ]
  object DescribeServiceActionExecutionParameters
      extends Effect[
        DescribeServiceActionExecutionParametersRequest,
        AwsError,
        zio.aws.servicecatalog.model.DescribeServiceActionExecutionParametersResponse.ReadOnly
      ]
  object ListServiceActionsForProvisioningArtifact
      extends Effect[
        ListServiceActionsForProvisioningArtifactRequest,
        AwsError,
        zio.aws.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse.ReadOnly
      ]
  object DeleteProduct
      extends Effect[
        DeleteProductRequest,
        AwsError,
        zio.aws.servicecatalog.model.DeleteProductResponse.ReadOnly
      ]
  object CreateProduct
      extends Effect[
        CreateProductRequest,
        AwsError,
        zio.aws.servicecatalog.model.CreateProductResponse.ReadOnly
      ]
  object AssociateTagOptionWithResource
      extends Effect[
        AssociateTagOptionWithResourceRequest,
        AwsError,
        zio.aws.servicecatalog.model.AssociateTagOptionWithResourceResponse.ReadOnly
      ]
  object AssociateBudgetWithResource
      extends Effect[
        AssociateBudgetWithResourceRequest,
        AwsError,
        zio.aws.servicecatalog.model.AssociateBudgetWithResourceResponse.ReadOnly
      ]
  object DeletePortfolio
      extends Effect[
        DeletePortfolioRequest,
        AwsError,
        zio.aws.servicecatalog.model.DeletePortfolioResponse.ReadOnly
      ]
  object UpdateProduct
      extends Effect[
        UpdateProductRequest,
        AwsError,
        zio.aws.servicecatalog.model.UpdateProductResponse.ReadOnly
      ]
  object UpdateConstraint
      extends Effect[
        UpdateConstraintRequest,
        AwsError,
        zio.aws.servicecatalog.model.UpdateConstraintResponse.ReadOnly
      ]
  object CopyProduct
      extends Effect[
        CopyProductRequest,
        AwsError,
        zio.aws.servicecatalog.model.CopyProductResponse.ReadOnly
      ]
  object DescribeProvisioningParameters
      extends Effect[
        DescribeProvisioningParametersRequest,
        AwsError,
        zio.aws.servicecatalog.model.DescribeProvisioningParametersResponse.ReadOnly
      ]
  object BatchAssociateServiceActionWithProvisioningArtifact
      extends Effect[
        BatchAssociateServiceActionWithProvisioningArtifactRequest,
        AwsError,
        zio.aws.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse.ReadOnly
      ]
  object ListPortfolioAccess
      extends Effect[
        ListPortfolioAccessRequest,
        AwsError,
        zio.aws.servicecatalog.model.ListPortfolioAccessResponse.ReadOnly
      ]
  object DescribeProvisioningArtifact
      extends Effect[
        DescribeProvisioningArtifactRequest,
        AwsError,
        zio.aws.servicecatalog.model.DescribeProvisioningArtifactResponse.ReadOnly
      ]
  object SearchProductsAsAdmin
      extends Effect[
        SearchProductsAsAdminRequest,
        AwsError,
        zio.aws.servicecatalog.model.SearchProductsAsAdminResponse.ReadOnly
      ]
  object RejectPortfolioShare
      extends Effect[
        RejectPortfolioShareRequest,
        AwsError,
        zio.aws.servicecatalog.model.RejectPortfolioShareResponse.ReadOnly
      ]
  object DisassociateServiceActionFromProvisioningArtifact
      extends Effect[
        DisassociateServiceActionFromProvisioningArtifactRequest,
        AwsError,
        zio.aws.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactResponse.ReadOnly
      ]
  object DescribeProductAsAdmin
      extends Effect[
        DescribeProductAsAdminRequest,
        AwsError,
        zio.aws.servicecatalog.model.DescribeProductAsAdminResponse.ReadOnly
      ]
  object ListStackInstancesForProvisionedProduct
      extends Effect[
        ListStackInstancesForProvisionedProductRequest,
        AwsError,
        zio.aws.servicecatalog.model.ListStackInstancesForProvisionedProductResponse.ReadOnly
      ]
  object NotifyUpdateProvisionedProductEngineWorkflowResult
      extends Effect[
        NotifyUpdateProvisionedProductEngineWorkflowResultRequest,
        AwsError,
        zio.aws.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultResponse.ReadOnly
      ]
  object CreatePortfolio
      extends Effect[
        CreatePortfolioRequest,
        AwsError,
        zio.aws.servicecatalog.model.CreatePortfolioResponse.ReadOnly
      ]
  object CreateProvisioningArtifact
      extends Effect[
        CreateProvisioningArtifactRequest,
        AwsError,
        zio.aws.servicecatalog.model.CreateProvisioningArtifactResponse.ReadOnly
      ]
  object BatchDisassociateServiceActionFromProvisioningArtifact
      extends Effect[
        BatchDisassociateServiceActionFromProvisioningArtifactRequest,
        AwsError,
        zio.aws.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse.ReadOnly
      ]
  object DisassociateProductFromPortfolio
      extends Effect[
        DisassociateProductFromPortfolioRequest,
        AwsError,
        zio.aws.servicecatalog.model.DisassociateProductFromPortfolioResponse.ReadOnly
      ]
  object DeleteServiceAction
      extends Effect[
        DeleteServiceActionRequest,
        AwsError,
        zio.aws.servicecatalog.model.DeleteServiceActionResponse.ReadOnly
      ]
  object SearchProvisionedProducts
      extends Effect[
        SearchProvisionedProductsRequest,
        AwsError,
        zio.aws.servicecatalog.model.SearchProvisionedProductsResponse.ReadOnly
      ]
  object ListBudgetsForResource
      extends Effect[
        ListBudgetsForResourceRequest,
        AwsError,
        zio.aws.servicecatalog.model.ListBudgetsForResourceResponse.ReadOnly
      ]
  object DescribeConstraint
      extends Effect[
        DescribeConstraintRequest,
        AwsError,
        zio.aws.servicecatalog.model.DescribeConstraintResponse.ReadOnly
      ]
  object DisableAWSOrganizationsAccess
      extends Effect[
        DisableAwsOrganizationsAccessRequest,
        AwsError,
        zio.aws.servicecatalog.model.DisableAwsOrganizationsAccessResponse.ReadOnly
      ]
  object DeleteProvisioningArtifact
      extends Effect[
        DeleteProvisioningArtifactRequest,
        AwsError,
        zio.aws.servicecatalog.model.DeleteProvisioningArtifactResponse.ReadOnly
      ]
  object UpdateProvisioningArtifact
      extends Effect[
        UpdateProvisioningArtifactRequest,
        AwsError,
        zio.aws.servicecatalog.model.UpdateProvisioningArtifactResponse.ReadOnly
      ]
  object ImportAsProvisionedProduct
      extends Effect[
        ImportAsProvisionedProductRequest,
        AwsError,
        zio.aws.servicecatalog.model.ImportAsProvisionedProductResponse.ReadOnly
      ]
  object UpdatePortfolio
      extends Effect[
        UpdatePortfolioRequest,
        AwsError,
        zio.aws.servicecatalog.model.UpdatePortfolioResponse.ReadOnly
      ]
  object ListLaunchPaths
      extends Effect[
        ListLaunchPathsRequest,
        AwsError,
        zio.aws.servicecatalog.model.ListLaunchPathsResponse.ReadOnly
      ]
  object ListProvisionedProductPlans
      extends Effect[
        ListProvisionedProductPlansRequest,
        AwsError,
        zio.aws.servicecatalog.model.ListProvisionedProductPlansResponse.ReadOnly
      ]
  object GetAWSOrganizationsAccessStatus
      extends Effect[
        GetAwsOrganizationsAccessStatusRequest,
        AwsError,
        zio.aws.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse.ReadOnly
      ]
  object CreateTagOption
      extends Effect[
        CreateTagOptionRequest,
        AwsError,
        zio.aws.servicecatalog.model.CreateTagOptionResponse.ReadOnly
      ]
  object DescribePortfolio
      extends Effect[
        DescribePortfolioRequest,
        AwsError,
        zio.aws.servicecatalog.model.DescribePortfolioResponse.ReadOnly
      ]
  object ListOrganizationPortfolioAccess
      extends Effect[
        ListOrganizationPortfolioAccessRequest,
        AwsError,
        zio.aws.servicecatalog.model.ListOrganizationPortfolioAccessResponse.ReadOnly
      ]
  object DescribePortfolioShares
      extends Effect[
        DescribePortfolioSharesRequest,
        AwsError,
        zio.aws.servicecatalog.model.DescribePortfolioSharesResponse.ReadOnly
      ]
  object UpdateProvisionedProduct
      extends Effect[
        UpdateProvisionedProductRequest,
        AwsError,
        zio.aws.servicecatalog.model.UpdateProvisionedProductResponse.ReadOnly
      ]
  object DescribeProduct
      extends Effect[
        DescribeProductRequest,
        AwsError,
        zio.aws.servicecatalog.model.DescribeProductResponse.ReadOnly
      ]
  object ListPortfoliosForProduct
      extends Effect[
        ListPortfoliosForProductRequest,
        AwsError,
        zio.aws.servicecatalog.model.ListPortfoliosForProductResponse.ReadOnly
      ]
  object ListTagOptions
      extends Effect[
        ListTagOptionsRequest,
        AwsError,
        zio.aws.servicecatalog.model.ListTagOptionsResponse.ReadOnly
      ]
  object NotifyTerminateProvisionedProductEngineWorkflowResult
      extends Effect[
        NotifyTerminateProvisionedProductEngineWorkflowResultRequest,
        AwsError,
        zio.aws.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultResponse.ReadOnly
      ]
  object DeleteConstraint
      extends Effect[
        DeleteConstraintRequest,
        AwsError,
        zio.aws.servicecatalog.model.DeleteConstraintResponse.ReadOnly
      ]
  object DescribeProvisionedProductPlan
      extends Effect[
        DescribeProvisionedProductPlanRequest,
        AwsError,
        zio.aws.servicecatalog.model.DescribeProvisionedProductPlanResponse.ReadOnly
      ]
  object ListRecordHistory
      extends Effect[
        ListRecordHistoryRequest,
        AwsError,
        zio.aws.servicecatalog.model.ListRecordHistoryResponse.ReadOnly
      ]
  object ListAcceptedPortfolioShares
      extends Effect[
        ListAcceptedPortfolioSharesRequest,
        AwsError,
        zio.aws.servicecatalog.model.ListAcceptedPortfolioSharesResponse.ReadOnly
      ]
  object DeletePortfolioShare
      extends Effect[
        DeletePortfolioShareRequest,
        AwsError,
        zio.aws.servicecatalog.model.DeletePortfolioShareResponse.ReadOnly
      ]
  object DescribePortfolioShareStatus
      extends Effect[
        DescribePortfolioShareStatusRequest,
        AwsError,
        zio.aws.servicecatalog.model.DescribePortfolioShareStatusResponse.ReadOnly
      ]
  object AcceptPortfolioShare
      extends Effect[
        AcceptPortfolioShareRequest,
        AwsError,
        zio.aws.servicecatalog.model.AcceptPortfolioShareResponse.ReadOnly
      ]
  object DescribeRecord
      extends Effect[
        DescribeRecordRequest,
        AwsError,
        zio.aws.servicecatalog.model.DescribeRecordResponse.ReadOnly
      ]
  object CreatePortfolioShare
      extends Effect[
        CreatePortfolioShareRequest,
        AwsError,
        zio.aws.servicecatalog.model.CreatePortfolioShareResponse.ReadOnly
      ]
  object DisassociateBudgetFromResource
      extends Effect[
        DisassociateBudgetFromResourceRequest,
        AwsError,
        zio.aws.servicecatalog.model.DisassociateBudgetFromResourceResponse.ReadOnly
      ]
  object ScanProvisionedProducts
      extends Effect[
        ScanProvisionedProductsRequest,
        AwsError,
        zio.aws.servicecatalog.model.ScanProvisionedProductsResponse.ReadOnly
      ]
  object NotifyProvisionProductEngineWorkflowResult
      extends Effect[
        NotifyProvisionProductEngineWorkflowResultRequest,
        AwsError,
        zio.aws.servicecatalog.model.NotifyProvisionProductEngineWorkflowResultResponse.ReadOnly
      ]
  object DeleteTagOption
      extends Effect[
        DeleteTagOptionRequest,
        AwsError,
        zio.aws.servicecatalog.model.DeleteTagOptionResponse.ReadOnly
      ]
  object UpdateServiceAction
      extends Effect[
        UpdateServiceActionRequest,
        AwsError,
        zio.aws.servicecatalog.model.UpdateServiceActionResponse.ReadOnly
      ]
  object ProvisionProduct
      extends Effect[
        ProvisionProductRequest,
        AwsError,
        zio.aws.servicecatalog.model.ProvisionProductResponse.ReadOnly
      ]
  object DescribeProductView
      extends Effect[
        DescribeProductViewRequest,
        AwsError,
        zio.aws.servicecatalog.model.DescribeProductViewResponse.ReadOnly
      ]
  object DescribeTagOption
      extends Effect[
        DescribeTagOptionRequest,
        AwsError,
        zio.aws.servicecatalog.model.DescribeTagOptionResponse.ReadOnly
      ]
  object DeleteProvisionedProductPlan
      extends Effect[
        DeleteProvisionedProductPlanRequest,
        AwsError,
        zio.aws.servicecatalog.model.DeleteProvisionedProductPlanResponse.ReadOnly
      ]
  object CreateServiceAction
      extends Effect[
        CreateServiceActionRequest,
        AwsError,
        zio.aws.servicecatalog.model.CreateServiceActionResponse.ReadOnly
      ]
  object ListConstraintsForPortfolio
      extends Effect[
        ListConstraintsForPortfolioRequest,
        AwsError,
        zio.aws.servicecatalog.model.ListConstraintsForPortfolioResponse.ReadOnly
      ]
  object DisassociatePrincipalFromPortfolio
      extends Effect[
        DisassociatePrincipalFromPortfolioRequest,
        AwsError,
        zio.aws.servicecatalog.model.DisassociatePrincipalFromPortfolioResponse.ReadOnly
      ]
  object ListPrincipalsForPortfolio
      extends Effect[
        ListPrincipalsForPortfolioRequest,
        AwsError,
        zio.aws.servicecatalog.model.ListPrincipalsForPortfolioResponse.ReadOnly
      ]
  object EnableAWSOrganizationsAccess
      extends Effect[
        EnableAwsOrganizationsAccessRequest,
        AwsError,
        zio.aws.servicecatalog.model.EnableAwsOrganizationsAccessResponse.ReadOnly
      ]
  object GetProvisionedProductOutputs
      extends Effect[
        GetProvisionedProductOutputsRequest,
        AwsError,
        zio.aws.servicecatalog.model.GetProvisionedProductOutputsResponse.ReadOnly
      ]
  object AssociateServiceActionWithProvisioningArtifact
      extends Effect[
        AssociateServiceActionWithProvisioningArtifactRequest,
        AwsError,
        zio.aws.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactResponse.ReadOnly
      ]
  object CreateProvisionedProductPlan
      extends Effect[
        CreateProvisionedProductPlanRequest,
        AwsError,
        zio.aws.servicecatalog.model.CreateProvisionedProductPlanResponse.ReadOnly
      ]
  object ExecuteProvisionedProductPlan
      extends Effect[
        ExecuteProvisionedProductPlanRequest,
        AwsError,
        zio.aws.servicecatalog.model.ExecuteProvisionedProductPlanResponse.ReadOnly
      ]
  object DescribeProvisionedProduct
      extends Effect[
        DescribeProvisionedProductRequest,
        AwsError,
        zio.aws.servicecatalog.model.DescribeProvisionedProductResponse.ReadOnly
      ]
  object ListPortfolios
      extends Effect[
        ListPortfoliosRequest,
        AwsError,
        zio.aws.servicecatalog.model.ListPortfoliosResponse.ReadOnly
      ]
  object SearchProducts
      extends Effect[
        SearchProductsRequest,
        AwsError,
        zio.aws.servicecatalog.model.SearchProductsResponse.ReadOnly
      ]
  object UpdatePortfolioShare
      extends Effect[
        UpdatePortfolioShareRequest,
        AwsError,
        zio.aws.servicecatalog.model.UpdatePortfolioShareResponse.ReadOnly
      ]
  object DescribeCopyProductStatus
      extends Effect[
        DescribeCopyProductStatusRequest,
        AwsError,
        zio.aws.servicecatalog.model.DescribeCopyProductStatusResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ServiceCatalog] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, ServiceCatalog] { rts =>
        zio.ZIO.succeed {
          new ServiceCatalog {
            val api: ServiceCatalogAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): ServiceCatalog = this
            def listResourcesForTagOption(
                request: ListResourcesForTagOptionRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.ListResourcesForTagOptionResponse.ReadOnly
            ] = proxy(ListResourcesForTagOption, request)
            def updateTagOption(request: UpdateTagOptionRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.UpdateTagOptionResponse.ReadOnly
            ] = proxy(UpdateTagOption, request)
            def disassociateTagOptionFromResource(
                request: DisassociateTagOptionFromResourceRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.DisassociateTagOptionFromResourceResponse.ReadOnly
            ] = proxy(DisassociateTagOptionFromResource, request)
            def listProvisioningArtifacts(
                request: ListProvisioningArtifactsRequest
            ): IO[AwsError, ReadOnly] =
              proxy(ListProvisioningArtifacts, request)
            def associatePrincipalWithPortfolio(
                request: AssociatePrincipalWithPortfolioRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.AssociatePrincipalWithPortfolioResponse.ReadOnly
            ] = proxy(AssociatePrincipalWithPortfolio, request)
            def listProvisioningArtifactsForServiceAction(
                request: ListProvisioningArtifactsForServiceActionRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse.ReadOnly
            ] = proxy(ListProvisioningArtifactsForServiceAction, request)
            def executeProvisionedProductServiceAction(
                request: ExecuteProvisionedProductServiceActionRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse.ReadOnly
            ] = proxy(ExecuteProvisionedProductServiceAction, request)
            def associateProductWithPortfolio(
                request: AssociateProductWithPortfolioRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.AssociateProductWithPortfolioResponse.ReadOnly
            ] = proxy(AssociateProductWithPortfolio, request)
            def describeServiceAction(
                request: DescribeServiceActionRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.DescribeServiceActionResponse.ReadOnly
            ] = proxy(DescribeServiceAction, request)
            def updateProvisionedProductProperties(
                request: UpdateProvisionedProductPropertiesRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesResponse.ReadOnly
            ] = proxy(UpdateProvisionedProductProperties, request)
            def createConstraint(request: CreateConstraintRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.CreateConstraintResponse.ReadOnly
            ] = proxy(CreateConstraint, request)
            def terminateProvisionedProduct(
                request: TerminateProvisionedProductRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.TerminateProvisionedProductResponse.ReadOnly
            ] = proxy(TerminateProvisionedProduct, request)
            def listServiceActions(request: ListServiceActionsRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.ListServiceActionsResponse.ReadOnly
            ] = proxy(ListServiceActions, request)
            def describeServiceActionExecutionParameters(
                request: DescribeServiceActionExecutionParametersRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.DescribeServiceActionExecutionParametersResponse.ReadOnly
            ] = proxy(DescribeServiceActionExecutionParameters, request)
            def listServiceActionsForProvisioningArtifact(
                request: ListServiceActionsForProvisioningArtifactRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse.ReadOnly
            ] = proxy(ListServiceActionsForProvisioningArtifact, request)
            def deleteProduct(request: DeleteProductRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.DeleteProductResponse.ReadOnly
            ] = proxy(DeleteProduct, request)
            def createProduct(request: CreateProductRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.CreateProductResponse.ReadOnly
            ] = proxy(CreateProduct, request)
            def associateTagOptionWithResource(
                request: AssociateTagOptionWithResourceRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.AssociateTagOptionWithResourceResponse.ReadOnly
            ] = proxy(AssociateTagOptionWithResource, request)
            def associateBudgetWithResource(
                request: AssociateBudgetWithResourceRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.AssociateBudgetWithResourceResponse.ReadOnly
            ] = proxy(AssociateBudgetWithResource, request)
            def deletePortfolio(request: DeletePortfolioRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.DeletePortfolioResponse.ReadOnly
            ] = proxy(DeletePortfolio, request)
            def updateProduct(request: UpdateProductRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.UpdateProductResponse.ReadOnly
            ] = proxy(UpdateProduct, request)
            def updateConstraint(request: UpdateConstraintRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.UpdateConstraintResponse.ReadOnly
            ] = proxy(UpdateConstraint, request)
            def copyProduct(request: CopyProductRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.CopyProductResponse.ReadOnly
            ] = proxy(CopyProduct, request)
            def describeProvisioningParameters(
                request: DescribeProvisioningParametersRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.DescribeProvisioningParametersResponse.ReadOnly
            ] = proxy(DescribeProvisioningParameters, request)
            def batchAssociateServiceActionWithProvisioningArtifact(
                request: BatchAssociateServiceActionWithProvisioningArtifactRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse.ReadOnly
            ] = proxy(
              BatchAssociateServiceActionWithProvisioningArtifact,
              request
            )
            def listPortfolioAccess(request: ListPortfolioAccessRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.ListPortfolioAccessResponse.ReadOnly
            ] = proxy(ListPortfolioAccess, request)
            def describeProvisioningArtifact(
                request: DescribeProvisioningArtifactRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.DescribeProvisioningArtifactResponse.ReadOnly
            ] = proxy(DescribeProvisioningArtifact, request)
            def searchProductsAsAdmin(
                request: SearchProductsAsAdminRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.SearchProductsAsAdminResponse.ReadOnly
            ] = proxy(SearchProductsAsAdmin, request)
            def rejectPortfolioShare(request: RejectPortfolioShareRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.RejectPortfolioShareResponse.ReadOnly
            ] = proxy(RejectPortfolioShare, request)
            def disassociateServiceActionFromProvisioningArtifact(
                request: DisassociateServiceActionFromProvisioningArtifactRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactResponse.ReadOnly
            ] =
              proxy(DisassociateServiceActionFromProvisioningArtifact, request)
            def describeProductAsAdmin(
                request: DescribeProductAsAdminRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.DescribeProductAsAdminResponse.ReadOnly
            ] = proxy(DescribeProductAsAdmin, request)
            def listStackInstancesForProvisionedProduct(
                request: ListStackInstancesForProvisionedProductRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.ListStackInstancesForProvisionedProductResponse.ReadOnly
            ] = proxy(ListStackInstancesForProvisionedProduct, request)
            def notifyUpdateProvisionedProductEngineWorkflowResult(
                request: NotifyUpdateProvisionedProductEngineWorkflowResultRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultResponse.ReadOnly
            ] =
              proxy(NotifyUpdateProvisionedProductEngineWorkflowResult, request)
            def createPortfolio(request: CreatePortfolioRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.CreatePortfolioResponse.ReadOnly
            ] = proxy(CreatePortfolio, request)
            def createProvisioningArtifact(
                request: CreateProvisioningArtifactRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.CreateProvisioningArtifactResponse.ReadOnly
            ] = proxy(CreateProvisioningArtifact, request)
            def batchDisassociateServiceActionFromProvisioningArtifact(
                request: BatchDisassociateServiceActionFromProvisioningArtifactRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse.ReadOnly
            ] = proxy(
              BatchDisassociateServiceActionFromProvisioningArtifact,
              request
            )
            def disassociateProductFromPortfolio(
                request: DisassociateProductFromPortfolioRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.DisassociateProductFromPortfolioResponse.ReadOnly
            ] = proxy(DisassociateProductFromPortfolio, request)
            def deleteServiceAction(request: DeleteServiceActionRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.DeleteServiceActionResponse.ReadOnly
            ] = proxy(DeleteServiceAction, request)
            def searchProvisionedProducts(
                request: SearchProvisionedProductsRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.SearchProvisionedProductsResponse.ReadOnly
            ] = proxy(SearchProvisionedProducts, request)
            def listBudgetsForResource(
                request: ListBudgetsForResourceRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.ListBudgetsForResourceResponse.ReadOnly
            ] = proxy(ListBudgetsForResource, request)
            def describeConstraint(request: DescribeConstraintRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.DescribeConstraintResponse.ReadOnly
            ] = proxy(DescribeConstraint, request)
            def disableAWSOrganizationsAccess(
                request: DisableAwsOrganizationsAccessRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.DisableAwsOrganizationsAccessResponse.ReadOnly
            ] = proxy(DisableAWSOrganizationsAccess, request)
            def deleteProvisioningArtifact(
                request: DeleteProvisioningArtifactRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.DeleteProvisioningArtifactResponse.ReadOnly
            ] = proxy(DeleteProvisioningArtifact, request)
            def updateProvisioningArtifact(
                request: UpdateProvisioningArtifactRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.UpdateProvisioningArtifactResponse.ReadOnly
            ] = proxy(UpdateProvisioningArtifact, request)
            def importAsProvisionedProduct(
                request: ImportAsProvisionedProductRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.ImportAsProvisionedProductResponse.ReadOnly
            ] = proxy(ImportAsProvisionedProduct, request)
            def updatePortfolio(request: UpdatePortfolioRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.UpdatePortfolioResponse.ReadOnly
            ] = proxy(UpdatePortfolio, request)
            def listLaunchPaths(request: ListLaunchPathsRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.ListLaunchPathsResponse.ReadOnly
            ] = proxy(ListLaunchPaths, request)
            def listProvisionedProductPlans(
                request: ListProvisionedProductPlansRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.ListProvisionedProductPlansResponse.ReadOnly
            ] = proxy(ListProvisionedProductPlans, request)
            def getAWSOrganizationsAccessStatus(
                request: GetAwsOrganizationsAccessStatusRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse.ReadOnly
            ] = proxy(GetAWSOrganizationsAccessStatus, request)
            def createTagOption(request: CreateTagOptionRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.CreateTagOptionResponse.ReadOnly
            ] = proxy(CreateTagOption, request)
            def describePortfolio(request: DescribePortfolioRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.DescribePortfolioResponse.ReadOnly
            ] = proxy(DescribePortfolio, request)
            def listOrganizationPortfolioAccess(
                request: ListOrganizationPortfolioAccessRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.ListOrganizationPortfolioAccessResponse.ReadOnly
            ] = proxy(ListOrganizationPortfolioAccess, request)
            def describePortfolioShares(
                request: DescribePortfolioSharesRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.DescribePortfolioSharesResponse.ReadOnly
            ] = proxy(DescribePortfolioShares, request)
            def updateProvisionedProduct(
                request: UpdateProvisionedProductRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.UpdateProvisionedProductResponse.ReadOnly
            ] = proxy(UpdateProvisionedProduct, request)
            def describeProduct(request: DescribeProductRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.DescribeProductResponse.ReadOnly
            ] = proxy(DescribeProduct, request)
            def listPortfoliosForProduct(
                request: ListPortfoliosForProductRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.ListPortfoliosForProductResponse.ReadOnly
            ] = proxy(ListPortfoliosForProduct, request)
            def listTagOptions(request: ListTagOptionsRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.ListTagOptionsResponse.ReadOnly
            ] = proxy(ListTagOptions, request)
            def notifyTerminateProvisionedProductEngineWorkflowResult(
                request: NotifyTerminateProvisionedProductEngineWorkflowResultRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultResponse.ReadOnly
            ] = proxy(
              NotifyTerminateProvisionedProductEngineWorkflowResult,
              request
            )
            def deleteConstraint(request: DeleteConstraintRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.DeleteConstraintResponse.ReadOnly
            ] = proxy(DeleteConstraint, request)
            def describeProvisionedProductPlan(
                request: DescribeProvisionedProductPlanRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.DescribeProvisionedProductPlanResponse.ReadOnly
            ] = proxy(DescribeProvisionedProductPlan, request)
            def listRecordHistory(request: ListRecordHistoryRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.ListRecordHistoryResponse.ReadOnly
            ] = proxy(ListRecordHistory, request)
            def listAcceptedPortfolioShares(
                request: ListAcceptedPortfolioSharesRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.ListAcceptedPortfolioSharesResponse.ReadOnly
            ] = proxy(ListAcceptedPortfolioShares, request)
            def deletePortfolioShare(request: DeletePortfolioShareRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.DeletePortfolioShareResponse.ReadOnly
            ] = proxy(DeletePortfolioShare, request)
            def describePortfolioShareStatus(
                request: DescribePortfolioShareStatusRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.DescribePortfolioShareStatusResponse.ReadOnly
            ] = proxy(DescribePortfolioShareStatus, request)
            def acceptPortfolioShare(request: AcceptPortfolioShareRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.AcceptPortfolioShareResponse.ReadOnly
            ] = proxy(AcceptPortfolioShare, request)
            def describeRecord(request: DescribeRecordRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.DescribeRecordResponse.ReadOnly
            ] = proxy(DescribeRecord, request)
            def createPortfolioShare(request: CreatePortfolioShareRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.CreatePortfolioShareResponse.ReadOnly
            ] = proxy(CreatePortfolioShare, request)
            def disassociateBudgetFromResource(
                request: DisassociateBudgetFromResourceRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.DisassociateBudgetFromResourceResponse.ReadOnly
            ] = proxy(DisassociateBudgetFromResource, request)
            def scanProvisionedProducts(
                request: ScanProvisionedProductsRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.ScanProvisionedProductsResponse.ReadOnly
            ] = proxy(ScanProvisionedProducts, request)
            def notifyProvisionProductEngineWorkflowResult(
                request: NotifyProvisionProductEngineWorkflowResultRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.NotifyProvisionProductEngineWorkflowResultResponse.ReadOnly
            ] = proxy(NotifyProvisionProductEngineWorkflowResult, request)
            def deleteTagOption(request: DeleteTagOptionRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.DeleteTagOptionResponse.ReadOnly
            ] = proxy(DeleteTagOption, request)
            def updateServiceAction(request: UpdateServiceActionRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.UpdateServiceActionResponse.ReadOnly
            ] = proxy(UpdateServiceAction, request)
            def provisionProduct(request: ProvisionProductRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.ProvisionProductResponse.ReadOnly
            ] = proxy(ProvisionProduct, request)
            def describeProductView(request: DescribeProductViewRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.DescribeProductViewResponse.ReadOnly
            ] = proxy(DescribeProductView, request)
            def describeTagOption(request: DescribeTagOptionRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.DescribeTagOptionResponse.ReadOnly
            ] = proxy(DescribeTagOption, request)
            def deleteProvisionedProductPlan(
                request: DeleteProvisionedProductPlanRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.DeleteProvisionedProductPlanResponse.ReadOnly
            ] = proxy(DeleteProvisionedProductPlan, request)
            def createServiceAction(request: CreateServiceActionRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.CreateServiceActionResponse.ReadOnly
            ] = proxy(CreateServiceAction, request)
            def listConstraintsForPortfolio(
                request: ListConstraintsForPortfolioRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.ListConstraintsForPortfolioResponse.ReadOnly
            ] = proxy(ListConstraintsForPortfolio, request)
            def disassociatePrincipalFromPortfolio(
                request: DisassociatePrincipalFromPortfolioRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.DisassociatePrincipalFromPortfolioResponse.ReadOnly
            ] = proxy(DisassociatePrincipalFromPortfolio, request)
            def listPrincipalsForPortfolio(
                request: ListPrincipalsForPortfolioRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.ListPrincipalsForPortfolioResponse.ReadOnly
            ] = proxy(ListPrincipalsForPortfolio, request)
            def enableAWSOrganizationsAccess(
                request: EnableAwsOrganizationsAccessRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.EnableAwsOrganizationsAccessResponse.ReadOnly
            ] = proxy(EnableAWSOrganizationsAccess, request)
            def getProvisionedProductOutputs(
                request: GetProvisionedProductOutputsRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.GetProvisionedProductOutputsResponse.ReadOnly
            ] = proxy(GetProvisionedProductOutputs, request)
            def associateServiceActionWithProvisioningArtifact(
                request: AssociateServiceActionWithProvisioningArtifactRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactResponse.ReadOnly
            ] = proxy(AssociateServiceActionWithProvisioningArtifact, request)
            def createProvisionedProductPlan(
                request: CreateProvisionedProductPlanRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.CreateProvisionedProductPlanResponse.ReadOnly
            ] = proxy(CreateProvisionedProductPlan, request)
            def executeProvisionedProductPlan(
                request: ExecuteProvisionedProductPlanRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.ExecuteProvisionedProductPlanResponse.ReadOnly
            ] = proxy(ExecuteProvisionedProductPlan, request)
            def describeProvisionedProduct(
                request: DescribeProvisionedProductRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.DescribeProvisionedProductResponse.ReadOnly
            ] = proxy(DescribeProvisionedProduct, request)
            def listPortfolios(request: ListPortfoliosRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.ListPortfoliosResponse.ReadOnly
            ] = proxy(ListPortfolios, request)
            def searchProducts(request: SearchProductsRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.SearchProductsResponse.ReadOnly
            ] = proxy(SearchProducts, request)
            def updatePortfolioShare(request: UpdatePortfolioShareRequest): IO[
              AwsError,
              zio.aws.servicecatalog.model.UpdatePortfolioShareResponse.ReadOnly
            ] = proxy(UpdatePortfolioShare, request)
            def describeCopyProductStatus(
                request: DescribeCopyProductStatusRequest
            ): IO[
              AwsError,
              zio.aws.servicecatalog.model.DescribeCopyProductStatusResponse.ReadOnly
            ] = proxy(DescribeCopyProductStatus, request)
          }
        }
      }
    }
  }
}
