package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{PropertyValue, Id}
import scala.jdk.CollectionConverters._
final case class UpdateProvisionedProductPropertiesResponse(
    provisionedProductId: Optional[Id] = Optional.Absent,
    provisionedProductProperties: Optional[
      Map[zio.aws.servicecatalog.model.PropertyKey, PropertyValue]
    ] = Optional.Absent,
    recordId: Optional[Id] = Optional.Absent,
    status: Optional[zio.aws.servicecatalog.model.RecordStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesResponse = {
    import UpdateProvisionedProductPropertiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesResponse
      .builder()
      .optionallyWith(
        provisionedProductId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisionedProductId)
      .optionallyWith(
        provisionedProductProperties.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (PropertyValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.provisionedProductPropertiesWithStrings)
      .optionallyWith(
        recordId.map(value => Id.unwrap(value): java.lang.String)
      )(_.recordId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesResponse.ReadOnly =
    zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesResponse
      .wrap(buildAwsValue())
}
object UpdateProvisionedProductPropertiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesResponse =
      zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesResponse(
        provisionedProductId.map(value => value),
        provisionedProductProperties.map(value => value),
        recordId.map(value => value),
        status.map(value => value)
      )
    def provisionedProductId: Optional[Id]
    def provisionedProductProperties
        : Optional[Map[zio.aws.servicecatalog.model.PropertyKey, PropertyValue]]
    def recordId: Optional[Id]
    def status: Optional[zio.aws.servicecatalog.model.RecordStatus]
    def getProvisionedProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("provisionedProductId", provisionedProductId)
    def getProvisionedProductProperties: ZIO[Any, AwsError, Map[
      zio.aws.servicecatalog.model.PropertyKey,
      PropertyValue
    ]] = AwsError.unwrapOptionField(
      "provisionedProductProperties",
      provisionedProductProperties
    )
    def getRecordId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("recordId", recordId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.RecordStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesResponse
  ) extends zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesResponse.ReadOnly {
    override val provisionedProductId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedProductId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisionedProductProperties: Optional[
      Map[zio.aws.servicecatalog.model.PropertyKey, PropertyValue]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedProductProperties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.servicecatalog.model.PropertyKey.wrap(
              key
            ) -> zio.aws.servicecatalog.model.primitives.PropertyValue(value)
          })
          .toMap
      )
    override val recordId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.recordId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val status: Optional[zio.aws.servicecatalog.model.RecordStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.servicecatalog.model.RecordStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesResponse
  ): zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesResponse.ReadOnly =
    new Wrapper(impl)
}
