package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{UniqueTagValue, UniqueTagKey}
import scala.jdk.CollectionConverters._
final case class UniqueTagResourceIdentifier(
    key: Optional[UniqueTagKey] = Optional.Absent,
    value: Optional[UniqueTagValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UniqueTagResourceIdentifier = {
    import UniqueTagResourceIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UniqueTagResourceIdentifier
      .builder()
      .optionallyWith(
        key.map(value => UniqueTagKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => UniqueTagValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.UniqueTagResourceIdentifier.ReadOnly =
    zio.aws.servicecatalog.model.UniqueTagResourceIdentifier
      .wrap(buildAwsValue())
}
object UniqueTagResourceIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UniqueTagResourceIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.UniqueTagResourceIdentifier =
      zio.aws.servicecatalog.model.UniqueTagResourceIdentifier(
        key.map(value => value),
        value.map(value => value)
      )
    def key: Optional[UniqueTagKey]
    def value: Optional[UniqueTagValue]
    def getKey: ZIO[Any, AwsError, UniqueTagKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, UniqueTagValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UniqueTagResourceIdentifier
  ) extends zio.aws.servicecatalog.model.UniqueTagResourceIdentifier.ReadOnly {
    override val key: Optional[UniqueTagKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.servicecatalog.model.primitives.UniqueTagKey(value))
    override val value: Optional[UniqueTagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.UniqueTagValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UniqueTagResourceIdentifier
  ): zio.aws.servicecatalog.model.UniqueTagResourceIdentifier.ReadOnly =
    new Wrapper(impl)
}
