package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SourceConnection(
    `type`: Optional[zio.aws.servicecatalog.model.SourceType] = Optional.Absent,
    connectionParameters: zio.aws.servicecatalog.model.SourceConnectionParameters
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.SourceConnection = {
    import SourceConnection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.SourceConnection
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .connectionParameters(connectionParameters.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.SourceConnection.ReadOnly =
    zio.aws.servicecatalog.model.SourceConnection.wrap(buildAwsValue())
}
object SourceConnection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.SourceConnection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.SourceConnection =
      zio.aws.servicecatalog.model.SourceConnection(
        `type`.map(value => value),
        connectionParameters.asEditable
      )
    def `type`: Optional[zio.aws.servicecatalog.model.SourceType]
    def connectionParameters
        : zio.aws.servicecatalog.model.SourceConnectionParameters.ReadOnly
    def getType: ZIO[Any, AwsError, zio.aws.servicecatalog.model.SourceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getConnectionParameters: ZIO[
      Any,
      Nothing,
      zio.aws.servicecatalog.model.SourceConnectionParameters.ReadOnly
    ] = ZIO.succeed(connectionParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.SourceConnection
  ) extends zio.aws.servicecatalog.model.SourceConnection.ReadOnly {
    override val `type`: Optional[zio.aws.servicecatalog.model.SourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.servicecatalog.model.SourceType.wrap(value))
    override val connectionParameters
        : zio.aws.servicecatalog.model.SourceConnectionParameters.ReadOnly =
      zio.aws.servicecatalog.model.SourceConnectionParameters
        .wrap(impl.connectionParameters())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.SourceConnection
  ): zio.aws.servicecatalog.model.SourceConnection.ReadOnly = new Wrapper(impl)
}
