package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait ProvisioningArtifactType {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType
}
object ProvisioningArtifactType {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType
  ): zio.aws.servicecatalog.model.ProvisioningArtifactType = value match {
    case software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType.CLOUD_FORMATION_TEMPLATE =>
      val r = CLOUD_FORMATION_TEMPLATE
      r
    case software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType.MARKETPLACE_AMI =>
      val r = MARKETPLACE_AMI
      r
    case software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType.MARKETPLACE_CAR =>
      val r = MARKETPLACE_CAR
      r
    case software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType.TERRAFORM_OPEN_SOURCE =>
      val r = TERRAFORM_OPEN_SOURCE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.ProvisioningArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType =
      software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType.UNKNOWN_TO_SDK_VERSION
  }
  case object CLOUD_FORMATION_TEMPLATE
      extends zio.aws.servicecatalog.model.ProvisioningArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType =
      software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType.CLOUD_FORMATION_TEMPLATE
  }
  case object MARKETPLACE_AMI
      extends zio.aws.servicecatalog.model.ProvisioningArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType =
      software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType.MARKETPLACE_AMI
  }
  case object MARKETPLACE_CAR
      extends zio.aws.servicecatalog.model.ProvisioningArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType =
      software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType.MARKETPLACE_CAR
  }
  case object TERRAFORM_OPEN_SOURCE
      extends zio.aws.servicecatalog.model.ProvisioningArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType =
      software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType.TERRAFORM_OPEN_SOURCE
  }
}
