package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{
  CreationTime,
  ProvisioningArtifactName,
  ProvisioningArtifactActive,
  SourceRevision,
  Id
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ProvisioningArtifactDetail(
    id: Optional[Id] = Optional.Absent,
    name: Optional[ProvisioningArtifactName] = Optional.Absent,
    description: Optional[ProvisioningArtifactName] = Optional.Absent,
    `type`: Optional[zio.aws.servicecatalog.model.ProvisioningArtifactType] =
      Optional.Absent,
    createdTime: Optional[CreationTime] = Optional.Absent,
    active: Optional[ProvisioningArtifactActive] = Optional.Absent,
    guidance: Optional[
      zio.aws.servicecatalog.model.ProvisioningArtifactGuidance
    ] = Optional.Absent,
    sourceRevision: Optional[SourceRevision] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactDetail = {
    import ProvisioningArtifactDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactDetail
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        name.map(value =>
          ProvisioningArtifactName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ProvisioningArtifactName.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        createdTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        active.map(value =>
          ProvisioningArtifactActive.unwrap(value): java.lang.Boolean
        )
      )(_.active)
      .optionallyWith(guidance.map(value => value.unwrap))(_.guidance)
      .optionallyWith(
        sourceRevision.map(value =>
          SourceRevision.unwrap(value): java.lang.String
        )
      )(_.sourceRevision)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisioningArtifactDetail.ReadOnly =
    zio.aws.servicecatalog.model.ProvisioningArtifactDetail
      .wrap(buildAwsValue())
}
object ProvisioningArtifactDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisioningArtifactDetail =
      zio.aws.servicecatalog.model.ProvisioningArtifactDetail(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        `type`.map(value => value),
        createdTime.map(value => value),
        active.map(value => value),
        guidance.map(value => value),
        sourceRevision.map(value => value)
      )
    def id: Optional[Id]
    def name: Optional[ProvisioningArtifactName]
    def description: Optional[ProvisioningArtifactName]
    def `type`: Optional[zio.aws.servicecatalog.model.ProvisioningArtifactType]
    def createdTime: Optional[CreationTime]
    def active: Optional[ProvisioningArtifactActive]
    def guidance
        : Optional[zio.aws.servicecatalog.model.ProvisioningArtifactGuidance]
    def sourceRevision: Optional[SourceRevision]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ProvisioningArtifactName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ProvisioningArtifactName] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisioningArtifactType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getCreatedTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getActive: ZIO[Any, AwsError, ProvisioningArtifactActive] =
      AwsError.unwrapOptionField("active", active)
    def getGuidance: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisioningArtifactGuidance
    ] = AwsError.unwrapOptionField("guidance", guidance)
    def getSourceRevision: ZIO[Any, AwsError, SourceRevision] =
      AwsError.unwrapOptionField("sourceRevision", sourceRevision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactDetail
  ) extends zio.aws.servicecatalog.model.ProvisioningArtifactDetail.ReadOnly {
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val name: Optional[ProvisioningArtifactName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisioningArtifactName(value)
        )
    override val description: Optional[ProvisioningArtifactName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisioningArtifactName(value)
        )
    override val `type`
        : Optional[zio.aws.servicecatalog.model.ProvisioningArtifactType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.servicecatalog.model.ProvisioningArtifactType.wrap(value)
        )
    override val createdTime: Optional[CreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.servicecatalog.model.primitives.CreationTime(value))
    override val active: Optional[ProvisioningArtifactActive] =
      zio.aws.core.internal
        .optionalFromNullable(impl.active())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisioningArtifactActive(value)
        )
    override val guidance
        : Optional[zio.aws.servicecatalog.model.ProvisioningArtifactGuidance] =
      zio.aws.core.internal
        .optionalFromNullable(impl.guidance())
        .map(value =>
          zio.aws.servicecatalog.model.ProvisioningArtifactGuidance.wrap(value)
        )
    override val sourceRevision: Optional[SourceRevision] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceRevision())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.SourceRevision(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactDetail
  ): zio.aws.servicecatalog.model.ProvisioningArtifactDetail.ReadOnly =
    new Wrapper(impl)
}
