package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait PortfolioShareType {
  def unwrap
      : software.amazon.awssdk.services.servicecatalog.model.PortfolioShareType
}
object PortfolioShareType {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.PortfolioShareType
  ): zio.aws.servicecatalog.model.PortfolioShareType = value match {
    case software.amazon.awssdk.services.servicecatalog.model.PortfolioShareType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.PortfolioShareType.IMPORTED =>
      val r = IMPORTED
      r
    case software.amazon.awssdk.services.servicecatalog.model.PortfolioShareType.AWS_SERVICECATALOG =>
      val r = AWS_SERVICECATALOG
      r
    case software.amazon.awssdk.services.servicecatalog.model.PortfolioShareType.AWS_ORGANIZATIONS =>
      val r = AWS_ORGANIZATIONS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.PortfolioShareType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.PortfolioShareType =
      software.amazon.awssdk.services.servicecatalog.model.PortfolioShareType.UNKNOWN_TO_SDK_VERSION
  }
  case object IMPORTED extends zio.aws.servicecatalog.model.PortfolioShareType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.PortfolioShareType =
      software.amazon.awssdk.services.servicecatalog.model.PortfolioShareType.IMPORTED
  }
  case object AWS_SERVICECATALOG
      extends zio.aws.servicecatalog.model.PortfolioShareType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.PortfolioShareType =
      software.amazon.awssdk.services.servicecatalog.model.PortfolioShareType.AWS_SERVICECATALOG
  }
  case object AWS_ORGANIZATIONS
      extends zio.aws.servicecatalog.model.PortfolioShareType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.PortfolioShareType =
      software.amazon.awssdk.services.servicecatalog.model.PortfolioShareType.AWS_ORGANIZATIONS
  }
}
