package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  IdempotencyToken,
  EngineWorkflowFailureReason,
  Id,
  EngineWorkflowToken
}
import scala.jdk.CollectionConverters._
final case class NotifyUpdateProvisionedProductEngineWorkflowResultRequest(
    workflowToken: EngineWorkflowToken,
    recordId: Id,
    status: zio.aws.servicecatalog.model.EngineWorkflowStatus,
    failureReason: Optional[EngineWorkflowFailureReason] = Optional.Absent,
    outputs: Optional[Iterable[zio.aws.servicecatalog.model.RecordOutput]] =
      Optional.Absent,
    idempotencyToken: IdempotencyToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultRequest = {
    import NotifyUpdateProvisionedProductEngineWorkflowResultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultRequest
      .builder()
      .workflowToken(
        EngineWorkflowToken.unwrap(workflowToken): java.lang.String
      )
      .recordId(Id.unwrap(recordId): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        failureReason.map(value =>
          EngineWorkflowFailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .idempotencyToken(
        IdempotencyToken.unwrap(idempotencyToken): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultRequest.ReadOnly =
    zio.aws.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultRequest
      .wrap(buildAwsValue())
}
object NotifyUpdateProvisionedProductEngineWorkflowResultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultRequest =
      zio.aws.servicecatalog.model
        .NotifyUpdateProvisionedProductEngineWorkflowResultRequest(
          workflowToken,
          recordId,
          status,
          failureReason.map(value => value),
          outputs.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          idempotencyToken
        )
    def workflowToken: EngineWorkflowToken
    def recordId: Id
    def status: zio.aws.servicecatalog.model.EngineWorkflowStatus
    def failureReason: Optional[EngineWorkflowFailureReason]
    def outputs
        : Optional[List[zio.aws.servicecatalog.model.RecordOutput.ReadOnly]]
    def idempotencyToken: IdempotencyToken
    def getWorkflowToken: ZIO[Any, Nothing, EngineWorkflowToken] =
      ZIO.succeed(workflowToken)
    def getRecordId: ZIO[Any, Nothing, Id] = ZIO.succeed(recordId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.servicecatalog.model.EngineWorkflowStatus] =
      ZIO.succeed(status)
    def getFailureReason: ZIO[Any, AwsError, EngineWorkflowFailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getOutputs: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.RecordOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("outputs", outputs)
    def getIdempotencyToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultRequest
  ) extends zio.aws.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultRequest.ReadOnly {
    override val workflowToken: EngineWorkflowToken =
      zio.aws.servicecatalog.model.primitives
        .EngineWorkflowToken(impl.workflowToken())
    override val recordId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.recordId())
    override val status: zio.aws.servicecatalog.model.EngineWorkflowStatus =
      zio.aws.servicecatalog.model.EngineWorkflowStatus.wrap(impl.status())
    override val failureReason: Optional[EngineWorkflowFailureReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReason())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .EngineWorkflowFailureReason(value)
        )
    override val outputs
        : Optional[List[zio.aws.servicecatalog.model.RecordOutput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.RecordOutput.wrap(item)
          }.toList
        )
    override val idempotencyToken: IdempotencyToken =
      zio.aws.servicecatalog.model.primitives
        .IdempotencyToken(impl.idempotencyToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultRequest
  ): zio.aws.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultRequest.ReadOnly =
    new Wrapper(impl)
}
