package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{
  Id,
  LastSuccessfulSyncTime,
  LastSyncStatusMessage,
  LastSyncTime
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class LastSync(
    lastSyncTime: Optional[LastSyncTime] = Optional.Absent,
    lastSyncStatus: Optional[zio.aws.servicecatalog.model.LastSyncStatus] =
      Optional.Absent,
    lastSyncStatusMessage: Optional[LastSyncStatusMessage] = Optional.Absent,
    lastSuccessfulSyncTime: Optional[LastSuccessfulSyncTime] = Optional.Absent,
    lastSuccessfulSyncProvisioningArtifactId: Optional[Id] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.LastSync = {
    import LastSync.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.LastSync
      .builder()
      .optionallyWith(
        lastSyncTime.map(value => LastSyncTime.unwrap(value): Instant)
      )(_.lastSyncTime)
      .optionallyWith(lastSyncStatus.map(value => value.unwrap))(
        _.lastSyncStatus
      )
      .optionallyWith(
        lastSyncStatusMessage.map(value =>
          LastSyncStatusMessage.unwrap(value): java.lang.String
        )
      )(_.lastSyncStatusMessage)
      .optionallyWith(
        lastSuccessfulSyncTime.map(value =>
          LastSuccessfulSyncTime.unwrap(value): Instant
        )
      )(_.lastSuccessfulSyncTime)
      .optionallyWith(
        lastSuccessfulSyncProvisioningArtifactId.map(value =>
          Id.unwrap(value): java.lang.String
        )
      )(_.lastSuccessfulSyncProvisioningArtifactId)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.LastSync.ReadOnly =
    zio.aws.servicecatalog.model.LastSync.wrap(buildAwsValue())
}
object LastSync {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.LastSync
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.LastSync =
      zio.aws.servicecatalog.model.LastSync(
        lastSyncTime.map(value => value),
        lastSyncStatus.map(value => value),
        lastSyncStatusMessage.map(value => value),
        lastSuccessfulSyncTime.map(value => value),
        lastSuccessfulSyncProvisioningArtifactId.map(value => value)
      )
    def lastSyncTime: Optional[LastSyncTime]
    def lastSyncStatus: Optional[zio.aws.servicecatalog.model.LastSyncStatus]
    def lastSyncStatusMessage: Optional[LastSyncStatusMessage]
    def lastSuccessfulSyncTime: Optional[LastSuccessfulSyncTime]
    def lastSuccessfulSyncProvisioningArtifactId: Optional[Id]
    def getLastSyncTime: ZIO[Any, AwsError, LastSyncTime] =
      AwsError.unwrapOptionField("lastSyncTime", lastSyncTime)
    def getLastSyncStatus
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.LastSyncStatus] =
      AwsError.unwrapOptionField("lastSyncStatus", lastSyncStatus)
    def getLastSyncStatusMessage: ZIO[Any, AwsError, LastSyncStatusMessage] =
      AwsError.unwrapOptionField("lastSyncStatusMessage", lastSyncStatusMessage)
    def getLastSuccessfulSyncTime: ZIO[Any, AwsError, LastSuccessfulSyncTime] =
      AwsError.unwrapOptionField(
        "lastSuccessfulSyncTime",
        lastSuccessfulSyncTime
      )
    def getLastSuccessfulSyncProvisioningArtifactId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField(
        "lastSuccessfulSyncProvisioningArtifactId",
        lastSuccessfulSyncProvisioningArtifactId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.LastSync
  ) extends zio.aws.servicecatalog.model.LastSync.ReadOnly {
    override val lastSyncTime: Optional[LastSyncTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastSyncTime())
      .map(value => zio.aws.servicecatalog.model.primitives.LastSyncTime(value))
    override val lastSyncStatus
        : Optional[zio.aws.servicecatalog.model.LastSyncStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSyncStatus())
        .map(value => zio.aws.servicecatalog.model.LastSyncStatus.wrap(value))
    override val lastSyncStatusMessage: Optional[LastSyncStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSyncStatusMessage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.LastSyncStatusMessage(value)
        )
    override val lastSuccessfulSyncTime: Optional[LastSuccessfulSyncTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSuccessfulSyncTime())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.LastSuccessfulSyncTime(value)
        )
    override val lastSuccessfulSyncProvisioningArtifactId: Optional[Id] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSuccessfulSyncProvisioningArtifactId())
        .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.LastSync
  ): zio.aws.servicecatalog.model.LastSync.ReadOnly = new Wrapper(impl)
}
