package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExecuteProvisionedProductServiceActionResponse(
    recordDetail: Optional[zio.aws.servicecatalog.model.RecordDetail] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse = {
    import ExecuteProvisionedProductServiceActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse
      .builder()
      .optionallyWith(recordDetail.map(value => value.buildAwsValue()))(
        _.recordDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse.ReadOnly =
    zio.aws.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse
      .wrap(buildAwsValue())
}
object ExecuteProvisionedProductServiceActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse =
      zio.aws.servicecatalog.model
        .ExecuteProvisionedProductServiceActionResponse(
          recordDetail.map(value => value.asEditable)
        )
    def recordDetail
        : Optional[zio.aws.servicecatalog.model.RecordDetail.ReadOnly]
    def getRecordDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.RecordDetail.ReadOnly
    ] = AwsError.unwrapOptionField("recordDetail", recordDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse
  ) extends zio.aws.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse.ReadOnly {
    override val recordDetail
        : Optional[zio.aws.servicecatalog.model.RecordDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordDetail())
        .map(value => zio.aws.servicecatalog.model.RecordDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse
  ): zio.aws.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse.ReadOnly =
    new Wrapper(impl)
}
