package zio.aws.servicecatalog
import zio.aws.servicecatalog.model.ListProvisioningArtifactsResponse.ReadOnly
import software.amazon.awssdk.services.servicecatalog.{
  ServiceCatalogAsyncClientBuilder,
  ServiceCatalogAsyncClient
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.aws.servicecatalog.model.{
  DescribePortfolioSharesRequest,
  ListServiceActionsRequest,
  CreatePortfolioShareRequest,
  UpdateConstraintRequest,
  ListPrincipalsForPortfolioRequest,
  EnableAwsOrganizationsAccessRequest,
  DescribeProductAsAdminRequest,
  DeleteTagOptionRequest,
  AssociateServiceActionWithProvisioningArtifactRequest,
  SearchProductsAsAdminRequest,
  NotifyTerminateProvisionedProductEngineWorkflowResultRequest,
  ExecuteProvisionedProductPlanRequest,
  ImportAsProvisionedProductRequest,
  AssociateBudgetWithResourceRequest,
  BatchAssociateServiceActionWithProvisioningArtifactRequest,
  AcceptPortfolioShareRequest,
  AssociateTagOptionWithResourceRequest,
  UpdateProvisionedProductPropertiesRequest,
  ListPortfoliosRequest,
  SearchProductsRequest,
  UpdateTagOptionRequest,
  ListOrganizationPortfolioAccessRequest,
  UpdateProductRequest,
  DescribeRecordRequest,
  UpdatePortfolioShareRequest,
  DescribeProvisionedProductRequest,
  DisassociatePrincipalFromPortfolioRequest,
  DisassociateProductFromPortfolioRequest,
  DescribeProvisionedProductPlanRequest,
  ListBudgetsForResourceRequest,
  DescribeProductRequest,
  CreateProvisionedProductPlanRequest,
  ListStackInstancesForProvisionedProductRequest,
  SearchProvisionedProductsRequest,
  ListLaunchPathsRequest,
  ScanProvisionedProductsRequest,
  DeleteConstraintRequest,
  AssociatePrincipalWithPortfolioRequest,
  CreatePortfolioRequest,
  DeleteServiceActionRequest,
  ListServiceActionsForProvisioningArtifactRequest,
  DescribePortfolioRequest,
  DeleteProductRequest,
  ListConstraintsForPortfolioRequest,
  DeleteProvisionedProductPlanRequest,
  DescribeTagOptionRequest,
  GetAwsOrganizationsAccessStatusRequest,
  NotifyUpdateProvisionedProductEngineWorkflowResultRequest,
  ListProvisionedProductPlansRequest,
  CreateTagOptionRequest,
  DescribeServiceActionRequest,
  DescribeServiceActionExecutionParametersRequest,
  DisassociateBudgetFromResourceRequest,
  AssociateProductWithPortfolioRequest,
  DescribePortfolioShareStatusRequest,
  UpdatePortfolioRequest,
  UpdateServiceActionRequest,
  DescribeCopyProductStatusRequest,
  ListTagOptionsRequest,
  CreateConstraintRequest,
  CreateProvisioningArtifactRequest,
  CreateServiceActionRequest,
  ListAcceptedPortfolioSharesRequest,
  ProvisionProductRequest,
  DescribeProductViewRequest,
  TerminateProvisionedProductRequest,
  UpdateProvisionedProductRequest,
  GetProvisionedProductOutputsRequest,
  DisassociateServiceActionFromProvisioningArtifactRequest,
  ListPortfoliosForProductRequest,
  DescribeProvisioningArtifactRequest,
  DeletePortfolioRequest,
  BatchDisassociateServiceActionFromProvisioningArtifactRequest,
  DisableAwsOrganizationsAccessRequest,
  CreateProductRequest,
  ListPortfolioAccessRequest,
  DisassociateTagOptionFromResourceRequest,
  UpdateProvisioningArtifactRequest,
  ListProvisioningArtifactsForServiceActionRequest,
  DescribeConstraintRequest,
  CopyProductRequest,
  ListResourcesForTagOptionRequest,
  ExecuteProvisionedProductServiceActionRequest,
  DeletePortfolioShareRequest,
  DeleteProvisioningArtifactRequest,
  ListRecordHistoryRequest,
  DescribeProvisioningParametersRequest,
  NotifyProvisionProductEngineWorkflowResultRequest,
  RejectPortfolioShareRequest,
  ListProvisioningArtifactsRequest
}
import software.amazon.awssdk.services.servicecatalog.model.{
  ListConstraintsForPortfolioResponse,
  ProvisionProductResponse,
  DeleteServiceActionResponse,
  RejectPortfolioShareResponse,
  CreateTagOptionResponse,
  ListProvisioningArtifactsResponse,
  ListProvisioningArtifactsForServiceActionResponse,
  UpdateTagOptionResponse,
  AssociateProductWithPortfolioResponse,
  DeleteTagOptionResponse,
  NotifyProvisionProductEngineWorkflowResultResponse,
  ListLaunchPathsResponse,
  ListServiceActionsForProvisioningArtifactResponse,
  ListProvisionedProductPlansResponse,
  DescribeProductViewResponse,
  TerminateProvisionedProductResponse,
  AssociateBudgetWithResourceResponse,
  SearchProductsResponse,
  BatchDisassociateServiceActionFromProvisioningArtifactResponse,
  DisassociateProductFromPortfolioResponse,
  DisableAwsOrganizationsAccessResponse,
  NotifyTerminateProvisionedProductEngineWorkflowResultResponse,
  AssociateTagOptionWithResourceResponse,
  UpdateConstraintResponse,
  ScanProvisionedProductsResponse,
  AssociatePrincipalWithPortfolioResponse,
  DescribePortfolioShareStatusResponse,
  DescribeServiceActionExecutionParametersResponse,
  DescribeProvisionedProductResponse,
  CopyProductResponse,
  CreateProvisionedProductPlanResponse,
  BatchAssociateServiceActionWithProvisioningArtifactResponse,
  DeletePortfolioResponse,
  ListBudgetsForResourceResponse,
  ListRecordHistoryResponse,
  UpdatePortfolioResponse,
  GetAwsOrganizationsAccessStatusResponse,
  DescribeProvisionedProductPlanResponse,
  DisassociateTagOptionFromResourceResponse,
  DisassociatePrincipalFromPortfolioResponse,
  CreateProductResponse,
  DescribeRecordResponse,
  ListOrganizationPortfolioAccessResponse,
  ListAcceptedPortfolioSharesResponse,
  DeleteProductResponse,
  CreateConstraintResponse,
  ListPortfoliosResponse,
  ListStackInstancesForProvisionedProductResponse,
  DeleteProvisionedProductPlanResponse,
  DeleteProvisioningArtifactResponse,
  CreateProvisioningArtifactResponse,
  GetProvisionedProductOutputsResponse,
  CreateServiceActionResponse,
  SearchProductsAsAdminResponse,
  SearchProvisionedProductsResponse,
  DescribeConstraintResponse,
  ExecuteProvisionedProductPlanResponse,
  UpdatePortfolioShareResponse,
  DisassociateBudgetFromResourceResponse,
  AssociateServiceActionWithProvisioningArtifactResponse,
  AcceptPortfolioShareResponse,
  UpdateProvisioningArtifactResponse,
  ListPrincipalsForPortfolioResponse,
  DescribeCopyProductStatusResponse,
  ImportAsProvisionedProductResponse,
  NotifyUpdateProvisionedProductEngineWorkflowResultResponse,
  UpdateProvisionedProductPropertiesResponse,
  DeleteConstraintResponse,
  ListServiceActionsResponse,
  CreatePortfolioResponse,
  UpdateProductResponse,
  UpdateServiceActionResponse,
  ExecuteProvisionedProductServiceActionResponse,
  DisassociateServiceActionFromProvisioningArtifactResponse,
  DescribeProductAsAdminResponse,
  UpdateProvisionedProductResponse,
  DescribePortfolioResponse,
  EnableAwsOrganizationsAccessResponse,
  DescribeTagOptionResponse,
  DescribeProvisioningParametersResponse,
  ListPortfoliosForProductResponse,
  ListResourcesForTagOptionResponse,
  DescribeServiceActionResponse,
  CreatePortfolioShareResponse,
  DescribeProductResponse,
  ListTagOptionsResponse,
  DescribeProvisioningArtifactResponse,
  DescribePortfolioSharesResponse,
  ListPortfolioAccessResponse,
  DeletePortfolioShareResponse
}
import scala.jdk.CollectionConverters._
trait ServiceCatalog extends AspectSupport[ServiceCatalog] {
  val api: ServiceCatalogAsyncClient
  def listResourcesForTagOption(request: ListResourcesForTagOptionRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.ListResourcesForTagOptionResponse.ReadOnly
  ]
  def updateTagOption(
      request: UpdateTagOptionRequest
  ): IO[AwsError, zio.aws.servicecatalog.model.UpdateTagOptionResponse.ReadOnly]
  def disassociateTagOptionFromResource(
      request: DisassociateTagOptionFromResourceRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.DisassociateTagOptionFromResourceResponse.ReadOnly
  ]
  def listProvisioningArtifacts(
      request: ListProvisioningArtifactsRequest
  ): IO[AwsError, ReadOnly]
  def associatePrincipalWithPortfolio(
      request: AssociatePrincipalWithPortfolioRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.AssociatePrincipalWithPortfolioResponse.ReadOnly
  ]
  def listProvisioningArtifactsForServiceAction(
      request: ListProvisioningArtifactsForServiceActionRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse.ReadOnly
  ]
  def executeProvisionedProductServiceAction(
      request: ExecuteProvisionedProductServiceActionRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse.ReadOnly
  ]
  def associateProductWithPortfolio(
      request: AssociateProductWithPortfolioRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.AssociateProductWithPortfolioResponse.ReadOnly
  ]
  def describeServiceAction(request: DescribeServiceActionRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.DescribeServiceActionResponse.ReadOnly
  ]
  def updateProvisionedProductProperties(
      request: UpdateProvisionedProductPropertiesRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesResponse.ReadOnly
  ]
  def createConstraint(request: CreateConstraintRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.CreateConstraintResponse.ReadOnly
  ]
  def terminateProvisionedProduct(
      request: TerminateProvisionedProductRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.TerminateProvisionedProductResponse.ReadOnly
  ]
  def listServiceActions(request: ListServiceActionsRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.ListServiceActionsResponse.ReadOnly
  ]
  def describeServiceActionExecutionParameters(
      request: DescribeServiceActionExecutionParametersRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.DescribeServiceActionExecutionParametersResponse.ReadOnly
  ]
  def listServiceActionsForProvisioningArtifact(
      request: ListServiceActionsForProvisioningArtifactRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse.ReadOnly
  ]
  def deleteProduct(
      request: DeleteProductRequest
  ): IO[AwsError, zio.aws.servicecatalog.model.DeleteProductResponse.ReadOnly]
  def createProduct(
      request: CreateProductRequest
  ): IO[AwsError, zio.aws.servicecatalog.model.CreateProductResponse.ReadOnly]
  def associateTagOptionWithResource(
      request: AssociateTagOptionWithResourceRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.AssociateTagOptionWithResourceResponse.ReadOnly
  ]
  def associateBudgetWithResource(
      request: AssociateBudgetWithResourceRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.AssociateBudgetWithResourceResponse.ReadOnly
  ]
  def deletePortfolio(
      request: DeletePortfolioRequest
  ): IO[AwsError, zio.aws.servicecatalog.model.DeletePortfolioResponse.ReadOnly]
  def updateProduct(
      request: UpdateProductRequest
  ): IO[AwsError, zio.aws.servicecatalog.model.UpdateProductResponse.ReadOnly]
  def updateConstraint(request: UpdateConstraintRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.UpdateConstraintResponse.ReadOnly
  ]
  def copyProduct(
      request: CopyProductRequest
  ): IO[AwsError, zio.aws.servicecatalog.model.CopyProductResponse.ReadOnly]
  def describeProvisioningParameters(
      request: DescribeProvisioningParametersRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.DescribeProvisioningParametersResponse.ReadOnly
  ]
  def batchAssociateServiceActionWithProvisioningArtifact(
      request: BatchAssociateServiceActionWithProvisioningArtifactRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse.ReadOnly
  ]
  def listPortfolioAccess(request: ListPortfolioAccessRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.ListPortfolioAccessResponse.ReadOnly
  ]
  def describeProvisioningArtifact(
      request: DescribeProvisioningArtifactRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.DescribeProvisioningArtifactResponse.ReadOnly
  ]
  def searchProductsAsAdmin(request: SearchProductsAsAdminRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.SearchProductsAsAdminResponse.ReadOnly
  ]
  def rejectPortfolioShare(request: RejectPortfolioShareRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.RejectPortfolioShareResponse.ReadOnly
  ]
  def disassociateServiceActionFromProvisioningArtifact(
      request: DisassociateServiceActionFromProvisioningArtifactRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactResponse.ReadOnly
  ]
  def describeProductAsAdmin(request: DescribeProductAsAdminRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.DescribeProductAsAdminResponse.ReadOnly
  ]
  def listStackInstancesForProvisionedProduct(
      request: ListStackInstancesForProvisionedProductRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.ListStackInstancesForProvisionedProductResponse.ReadOnly
  ]
  def notifyUpdateProvisionedProductEngineWorkflowResult(
      request: NotifyUpdateProvisionedProductEngineWorkflowResultRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultResponse.ReadOnly
  ]
  def createPortfolio(
      request: CreatePortfolioRequest
  ): IO[AwsError, zio.aws.servicecatalog.model.CreatePortfolioResponse.ReadOnly]
  def createProvisioningArtifact(
      request: CreateProvisioningArtifactRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.CreateProvisioningArtifactResponse.ReadOnly
  ]
  def batchDisassociateServiceActionFromProvisioningArtifact(
      request: BatchDisassociateServiceActionFromProvisioningArtifactRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse.ReadOnly
  ]
  def disassociateProductFromPortfolio(
      request: DisassociateProductFromPortfolioRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.DisassociateProductFromPortfolioResponse.ReadOnly
  ]
  def deleteServiceAction(request: DeleteServiceActionRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.DeleteServiceActionResponse.ReadOnly
  ]
  def searchProvisionedProducts(request: SearchProvisionedProductsRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.SearchProvisionedProductsResponse.ReadOnly
  ]
  def listBudgetsForResource(request: ListBudgetsForResourceRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.ListBudgetsForResourceResponse.ReadOnly
  ]
  def describeConstraint(request: DescribeConstraintRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.DescribeConstraintResponse.ReadOnly
  ]
  def disableAWSOrganizationsAccess(
      request: DisableAwsOrganizationsAccessRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.DisableAwsOrganizationsAccessResponse.ReadOnly
  ]
  def deleteProvisioningArtifact(
      request: DeleteProvisioningArtifactRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.DeleteProvisioningArtifactResponse.ReadOnly
  ]
  def updateProvisioningArtifact(
      request: UpdateProvisioningArtifactRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.UpdateProvisioningArtifactResponse.ReadOnly
  ]
  def importAsProvisionedProduct(
      request: ImportAsProvisionedProductRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.ImportAsProvisionedProductResponse.ReadOnly
  ]
  def updatePortfolio(
      request: UpdatePortfolioRequest
  ): IO[AwsError, zio.aws.servicecatalog.model.UpdatePortfolioResponse.ReadOnly]
  def listLaunchPaths(
      request: ListLaunchPathsRequest
  ): IO[AwsError, zio.aws.servicecatalog.model.ListLaunchPathsResponse.ReadOnly]
  def listProvisionedProductPlans(
      request: ListProvisionedProductPlansRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.ListProvisionedProductPlansResponse.ReadOnly
  ]
  def getAWSOrganizationsAccessStatus(
      request: GetAwsOrganizationsAccessStatusRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse.ReadOnly
  ]
  def createTagOption(
      request: CreateTagOptionRequest
  ): IO[AwsError, zio.aws.servicecatalog.model.CreateTagOptionResponse.ReadOnly]
  def describePortfolio(request: DescribePortfolioRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.DescribePortfolioResponse.ReadOnly
  ]
  def listOrganizationPortfolioAccess(
      request: ListOrganizationPortfolioAccessRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.ListOrganizationPortfolioAccessResponse.ReadOnly
  ]
  def describePortfolioShares(request: DescribePortfolioSharesRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.DescribePortfolioSharesResponse.ReadOnly
  ]
  def updateProvisionedProduct(request: UpdateProvisionedProductRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.UpdateProvisionedProductResponse.ReadOnly
  ]
  def describeProduct(
      request: DescribeProductRequest
  ): IO[AwsError, zio.aws.servicecatalog.model.DescribeProductResponse.ReadOnly]
  def listPortfoliosForProduct(request: ListPortfoliosForProductRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.ListPortfoliosForProductResponse.ReadOnly
  ]
  def listTagOptions(
      request: ListTagOptionsRequest
  ): IO[AwsError, zio.aws.servicecatalog.model.ListTagOptionsResponse.ReadOnly]
  def notifyTerminateProvisionedProductEngineWorkflowResult(
      request: NotifyTerminateProvisionedProductEngineWorkflowResultRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultResponse.ReadOnly
  ]
  def deleteConstraint(request: DeleteConstraintRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.DeleteConstraintResponse.ReadOnly
  ]
  def describeProvisionedProductPlan(
      request: DescribeProvisionedProductPlanRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.DescribeProvisionedProductPlanResponse.ReadOnly
  ]
  def listRecordHistory(request: ListRecordHistoryRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.ListRecordHistoryResponse.ReadOnly
  ]
  def listAcceptedPortfolioShares(
      request: ListAcceptedPortfolioSharesRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.ListAcceptedPortfolioSharesResponse.ReadOnly
  ]
  def deletePortfolioShare(request: DeletePortfolioShareRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.DeletePortfolioShareResponse.ReadOnly
  ]
  def describePortfolioShareStatus(
      request: DescribePortfolioShareStatusRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.DescribePortfolioShareStatusResponse.ReadOnly
  ]
  def acceptPortfolioShare(request: AcceptPortfolioShareRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.AcceptPortfolioShareResponse.ReadOnly
  ]
  def describeRecord(
      request: DescribeRecordRequest
  ): IO[AwsError, zio.aws.servicecatalog.model.DescribeRecordResponse.ReadOnly]
  def createPortfolioShare(request: CreatePortfolioShareRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.CreatePortfolioShareResponse.ReadOnly
  ]
  def disassociateBudgetFromResource(
      request: DisassociateBudgetFromResourceRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.DisassociateBudgetFromResourceResponse.ReadOnly
  ]
  def scanProvisionedProducts(request: ScanProvisionedProductsRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.ScanProvisionedProductsResponse.ReadOnly
  ]
  def notifyProvisionProductEngineWorkflowResult(
      request: NotifyProvisionProductEngineWorkflowResultRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.NotifyProvisionProductEngineWorkflowResultResponse.ReadOnly
  ]
  def deleteTagOption(
      request: DeleteTagOptionRequest
  ): IO[AwsError, zio.aws.servicecatalog.model.DeleteTagOptionResponse.ReadOnly]
  def updateServiceAction(request: UpdateServiceActionRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.UpdateServiceActionResponse.ReadOnly
  ]
  def provisionProduct(request: ProvisionProductRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.ProvisionProductResponse.ReadOnly
  ]
  def describeProductView(request: DescribeProductViewRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.DescribeProductViewResponse.ReadOnly
  ]
  def describeTagOption(request: DescribeTagOptionRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.DescribeTagOptionResponse.ReadOnly
  ]
  def deleteProvisionedProductPlan(
      request: DeleteProvisionedProductPlanRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.DeleteProvisionedProductPlanResponse.ReadOnly
  ]
  def createServiceAction(request: CreateServiceActionRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.CreateServiceActionResponse.ReadOnly
  ]
  def listConstraintsForPortfolio(
      request: ListConstraintsForPortfolioRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.ListConstraintsForPortfolioResponse.ReadOnly
  ]
  def disassociatePrincipalFromPortfolio(
      request: DisassociatePrincipalFromPortfolioRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.DisassociatePrincipalFromPortfolioResponse.ReadOnly
  ]
  def listPrincipalsForPortfolio(
      request: ListPrincipalsForPortfolioRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.ListPrincipalsForPortfolioResponse.ReadOnly
  ]
  def enableAWSOrganizationsAccess(
      request: EnableAwsOrganizationsAccessRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.EnableAwsOrganizationsAccessResponse.ReadOnly
  ]
  def getProvisionedProductOutputs(
      request: GetProvisionedProductOutputsRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.GetProvisionedProductOutputsResponse.ReadOnly
  ]
  def associateServiceActionWithProvisioningArtifact(
      request: AssociateServiceActionWithProvisioningArtifactRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactResponse.ReadOnly
  ]
  def createProvisionedProductPlan(
      request: CreateProvisionedProductPlanRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.CreateProvisionedProductPlanResponse.ReadOnly
  ]
  def executeProvisionedProductPlan(
      request: ExecuteProvisionedProductPlanRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.ExecuteProvisionedProductPlanResponse.ReadOnly
  ]
  def describeProvisionedProduct(
      request: DescribeProvisionedProductRequest
  ): IO[
    AwsError,
    zio.aws.servicecatalog.model.DescribeProvisionedProductResponse.ReadOnly
  ]
  def listPortfolios(
      request: ListPortfoliosRequest
  ): IO[AwsError, zio.aws.servicecatalog.model.ListPortfoliosResponse.ReadOnly]
  def searchProducts(
      request: SearchProductsRequest
  ): IO[AwsError, zio.aws.servicecatalog.model.SearchProductsResponse.ReadOnly]
  def updatePortfolioShare(request: UpdatePortfolioShareRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.UpdatePortfolioShareResponse.ReadOnly
  ]
  def describeCopyProductStatus(request: DescribeCopyProductStatusRequest): IO[
    AwsError,
    zio.aws.servicecatalog.model.DescribeCopyProductStatusResponse.ReadOnly
  ]
}
object ServiceCatalog {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ServiceCatalog] = customized(
    identity
  )
  def customized(
      customization: ServiceCatalogAsyncClientBuilder => ServiceCatalogAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ServiceCatalog] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ServiceCatalogAsyncClientBuilder => ServiceCatalogAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, ServiceCatalog] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ServiceCatalogAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[ServiceCatalogAsyncClient, ServiceCatalogAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      ServiceCatalogAsyncClient,
      ServiceCatalogAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new ServiceCatalogImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ServiceCatalogImpl[R](
      override val api: ServiceCatalogAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ServiceCatalog
      with AwsServiceBase[R] {
    override val serviceName: String = "ServiceCatalog"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ServiceCatalogImpl[R1] = new ServiceCatalogImpl(api, newAspect, r)
    def listResourcesForTagOption(
        request: ListResourcesForTagOptionRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.ListResourcesForTagOptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest,
      ListResourcesForTagOptionResponse
    ]("listResourcesForTagOption", api.listResourcesForTagOption)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.ListResourcesForTagOptionResponse.wrap)
      .provideEnvironment(r)
    def updateTagOption(request: UpdateTagOptionRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.UpdateTagOptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.UpdateTagOptionRequest,
      UpdateTagOptionResponse
    ]("updateTagOption", api.updateTagOption)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.UpdateTagOptionResponse.wrap)
      .provideEnvironment(r)
    def disassociateTagOptionFromResource(
        request: DisassociateTagOptionFromResourceRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.DisassociateTagOptionFromResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DisassociateTagOptionFromResourceRequest,
      DisassociateTagOptionFromResourceResponse
    ](
      "disassociateTagOptionFromResource",
      api.disassociateTagOptionFromResource
    )(request.buildAwsValue())
      .map(
        zio.aws.servicecatalog.model.DisassociateTagOptionFromResourceResponse.wrap
      )
      .provideEnvironment(r)
    def listProvisioningArtifacts(
        request: ListProvisioningArtifactsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsRequest,
      ListProvisioningArtifactsResponse
    ]("listProvisioningArtifacts", api.listProvisioningArtifacts)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.ListProvisioningArtifactsResponse.wrap)
      .provideEnvironment(r)
    def associatePrincipalWithPortfolio(
        request: AssociatePrincipalWithPortfolioRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.AssociatePrincipalWithPortfolioResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.AssociatePrincipalWithPortfolioRequest,
      AssociatePrincipalWithPortfolioResponse
    ]("associatePrincipalWithPortfolio", api.associatePrincipalWithPortfolio)(
      request.buildAwsValue()
    ).map(
      zio.aws.servicecatalog.model.AssociatePrincipalWithPortfolioResponse.wrap
    ).provideEnvironment(r)
    def listProvisioningArtifactsForServiceAction(
        request: ListProvisioningArtifactsForServiceActionRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest,
      ListProvisioningArtifactsForServiceActionResponse
    ](
      "listProvisioningArtifactsForServiceAction",
      api.listProvisioningArtifactsForServiceAction
    )(request.buildAwsValue())
      .map(
        zio.aws.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse.wrap
      )
      .provideEnvironment(r)
    def executeProvisionedProductServiceAction(
        request: ExecuteProvisionedProductServiceActionRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductServiceActionRequest,
      ExecuteProvisionedProductServiceActionResponse
    ](
      "executeProvisionedProductServiceAction",
      api.executeProvisionedProductServiceAction
    )(request.buildAwsValue())
      .map(
        zio.aws.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse.wrap
      )
      .provideEnvironment(r)
    def associateProductWithPortfolio(
        request: AssociateProductWithPortfolioRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.AssociateProductWithPortfolioResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.AssociateProductWithPortfolioRequest,
      AssociateProductWithPortfolioResponse
    ]("associateProductWithPortfolio", api.associateProductWithPortfolio)(
      request.buildAwsValue()
    ).map(
      zio.aws.servicecatalog.model.AssociateProductWithPortfolioResponse.wrap
    ).provideEnvironment(r)
    def describeServiceAction(request: DescribeServiceActionRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.DescribeServiceActionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionRequest,
      DescribeServiceActionResponse
    ]("describeServiceAction", api.describeServiceAction)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.DescribeServiceActionResponse.wrap)
      .provideEnvironment(r)
    def updateProvisionedProductProperties(
        request: UpdateProvisionedProductPropertiesRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesRequest,
      UpdateProvisionedProductPropertiesResponse
    ](
      "updateProvisionedProductProperties",
      api.updateProvisionedProductProperties
    )(request.buildAwsValue())
      .map(
        zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesResponse.wrap
      )
      .provideEnvironment(r)
    def createConstraint(request: CreateConstraintRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.CreateConstraintResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.CreateConstraintRequest,
      CreateConstraintResponse
    ]("createConstraint", api.createConstraint)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.CreateConstraintResponse.wrap)
      .provideEnvironment(r)
    def terminateProvisionedProduct(
        request: TerminateProvisionedProductRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.TerminateProvisionedProductResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductRequest,
      TerminateProvisionedProductResponse
    ]("terminateProvisionedProduct", api.terminateProvisionedProduct)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.TerminateProvisionedProductResponse.wrap)
      .provideEnvironment(r)
    def listServiceActions(request: ListServiceActionsRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.ListServiceActionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest,
      ListServiceActionsResponse
    ]("listServiceActions", api.listServiceActions)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.ListServiceActionsResponse.wrap)
      .provideEnvironment(r)
    def describeServiceActionExecutionParameters(
        request: DescribeServiceActionExecutionParametersRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.DescribeServiceActionExecutionParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionExecutionParametersRequest,
      DescribeServiceActionExecutionParametersResponse
    ](
      "describeServiceActionExecutionParameters",
      api.describeServiceActionExecutionParameters
    )(request.buildAwsValue())
      .map(
        zio.aws.servicecatalog.model.DescribeServiceActionExecutionParametersResponse.wrap
      )
      .provideEnvironment(r)
    def listServiceActionsForProvisioningArtifact(
        request: ListServiceActionsForProvisioningArtifactRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest,
      ListServiceActionsForProvisioningArtifactResponse
    ](
      "listServiceActionsForProvisioningArtifact",
      api.listServiceActionsForProvisioningArtifact
    )(request.buildAwsValue())
      .map(
        zio.aws.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse.wrap
      )
      .provideEnvironment(r)
    def deleteProduct(request: DeleteProductRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.DeleteProductResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DeleteProductRequest,
      DeleteProductResponse
    ]("deleteProduct", api.deleteProduct)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.DeleteProductResponse.wrap)
      .provideEnvironment(r)
    def createProduct(request: CreateProductRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.CreateProductResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.CreateProductRequest,
      CreateProductResponse
    ]("createProduct", api.createProduct)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.CreateProductResponse.wrap)
      .provideEnvironment(r)
    def associateTagOptionWithResource(
        request: AssociateTagOptionWithResourceRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.AssociateTagOptionWithResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.AssociateTagOptionWithResourceRequest,
      AssociateTagOptionWithResourceResponse
    ]("associateTagOptionWithResource", api.associateTagOptionWithResource)(
      request.buildAwsValue()
    ).map(
      zio.aws.servicecatalog.model.AssociateTagOptionWithResourceResponse.wrap
    ).provideEnvironment(r)
    def associateBudgetWithResource(
        request: AssociateBudgetWithResourceRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.AssociateBudgetWithResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.AssociateBudgetWithResourceRequest,
      AssociateBudgetWithResourceResponse
    ]("associateBudgetWithResource", api.associateBudgetWithResource)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.AssociateBudgetWithResourceResponse.wrap)
      .provideEnvironment(r)
    def deletePortfolio(request: DeletePortfolioRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.DeletePortfolioResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioRequest,
      DeletePortfolioResponse
    ]("deletePortfolio", api.deletePortfolio)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.DeletePortfolioResponse.wrap)
      .provideEnvironment(r)
    def updateProduct(request: UpdateProductRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.UpdateProductResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.UpdateProductRequest,
      UpdateProductResponse
    ]("updateProduct", api.updateProduct)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.UpdateProductResponse.wrap)
      .provideEnvironment(r)
    def updateConstraint(request: UpdateConstraintRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.UpdateConstraintResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintRequest,
      UpdateConstraintResponse
    ]("updateConstraint", api.updateConstraint)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.UpdateConstraintResponse.wrap)
      .provideEnvironment(r)
    def copyProduct(
        request: CopyProductRequest
    ): IO[AwsError, zio.aws.servicecatalog.model.CopyProductResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.servicecatalog.model.CopyProductRequest,
        CopyProductResponse
      ]("copyProduct", api.copyProduct)(request.buildAwsValue())
        .map(zio.aws.servicecatalog.model.CopyProductResponse.wrap)
        .provideEnvironment(r)
    def describeProvisioningParameters(
        request: DescribeProvisioningParametersRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.DescribeProvisioningParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersRequest,
      DescribeProvisioningParametersResponse
    ]("describeProvisioningParameters", api.describeProvisioningParameters)(
      request.buildAwsValue()
    ).map(
      zio.aws.servicecatalog.model.DescribeProvisioningParametersResponse.wrap
    ).provideEnvironment(r)
    def batchAssociateServiceActionWithProvisioningArtifact(
        request: BatchAssociateServiceActionWithProvisioningArtifactRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactRequest,
      BatchAssociateServiceActionWithProvisioningArtifactResponse
    ](
      "batchAssociateServiceActionWithProvisioningArtifact",
      api.batchAssociateServiceActionWithProvisioningArtifact
    )(request.buildAwsValue())
      .map(
        zio.aws.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse.wrap
      )
      .provideEnvironment(r)
    def listPortfolioAccess(request: ListPortfolioAccessRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.ListPortfolioAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest,
      ListPortfolioAccessResponse
    ]("listPortfolioAccess", api.listPortfolioAccess)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.ListPortfolioAccessResponse.wrap)
      .provideEnvironment(r)
    def describeProvisioningArtifact(
        request: DescribeProvisioningArtifactRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.DescribeProvisioningArtifactResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactRequest,
      DescribeProvisioningArtifactResponse
    ]("describeProvisioningArtifact", api.describeProvisioningArtifact)(
      request.buildAwsValue()
    ).map(
      zio.aws.servicecatalog.model.DescribeProvisioningArtifactResponse.wrap
    ).provideEnvironment(r)
    def searchProductsAsAdmin(request: SearchProductsAsAdminRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.SearchProductsAsAdminResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest,
      SearchProductsAsAdminResponse
    ]("searchProductsAsAdmin", api.searchProductsAsAdmin)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.SearchProductsAsAdminResponse.wrap)
      .provideEnvironment(r)
    def rejectPortfolioShare(request: RejectPortfolioShareRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.RejectPortfolioShareResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.RejectPortfolioShareRequest,
      RejectPortfolioShareResponse
    ]("rejectPortfolioShare", api.rejectPortfolioShare)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.RejectPortfolioShareResponse.wrap)
      .provideEnvironment(r)
    def disassociateServiceActionFromProvisioningArtifact(
        request: DisassociateServiceActionFromProvisioningArtifactRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactRequest,
      DisassociateServiceActionFromProvisioningArtifactResponse
    ](
      "disassociateServiceActionFromProvisioningArtifact",
      api.disassociateServiceActionFromProvisioningArtifact
    )(request.buildAwsValue())
      .map(
        zio.aws.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactResponse.wrap
      )
      .provideEnvironment(r)
    def describeProductAsAdmin(request: DescribeProductAsAdminRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.DescribeProductAsAdminResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminRequest,
      DescribeProductAsAdminResponse
    ]("describeProductAsAdmin", api.describeProductAsAdmin)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.DescribeProductAsAdminResponse.wrap)
      .provideEnvironment(r)
    def listStackInstancesForProvisionedProduct(
        request: ListStackInstancesForProvisionedProductRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.ListStackInstancesForProvisionedProductResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ListStackInstancesForProvisionedProductRequest,
      ListStackInstancesForProvisionedProductResponse
    ](
      "listStackInstancesForProvisionedProduct",
      api.listStackInstancesForProvisionedProduct
    )(request.buildAwsValue())
      .map(
        zio.aws.servicecatalog.model.ListStackInstancesForProvisionedProductResponse.wrap
      )
      .provideEnvironment(r)
    def notifyUpdateProvisionedProductEngineWorkflowResult(
        request: NotifyUpdateProvisionedProductEngineWorkflowResultRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultRequest,
      NotifyUpdateProvisionedProductEngineWorkflowResultResponse
    ](
      "notifyUpdateProvisionedProductEngineWorkflowResult",
      api.notifyUpdateProvisionedProductEngineWorkflowResult
    )(request.buildAwsValue())
      .map(
        zio.aws.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultResponse.wrap
      )
      .provideEnvironment(r)
    def createPortfolio(request: CreatePortfolioRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.CreatePortfolioResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioRequest,
      CreatePortfolioResponse
    ]("createPortfolio", api.createPortfolio)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.CreatePortfolioResponse.wrap)
      .provideEnvironment(r)
    def createProvisioningArtifact(
        request: CreateProvisioningArtifactRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.CreateProvisioningArtifactResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactRequest,
      CreateProvisioningArtifactResponse
    ]("createProvisioningArtifact", api.createProvisioningArtifact)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.CreateProvisioningArtifactResponse.wrap)
      .provideEnvironment(r)
    def batchDisassociateServiceActionFromProvisioningArtifact(
        request: BatchDisassociateServiceActionFromProvisioningArtifactRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactRequest,
      BatchDisassociateServiceActionFromProvisioningArtifactResponse
    ](
      "batchDisassociateServiceActionFromProvisioningArtifact",
      api.batchDisassociateServiceActionFromProvisioningArtifact
    )(request.buildAwsValue())
      .map(
        zio.aws.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse.wrap
      )
      .provideEnvironment(r)
    def disassociateProductFromPortfolio(
        request: DisassociateProductFromPortfolioRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.DisassociateProductFromPortfolioResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DisassociateProductFromPortfolioRequest,
      DisassociateProductFromPortfolioResponse
    ]("disassociateProductFromPortfolio", api.disassociateProductFromPortfolio)(
      request.buildAwsValue()
    ).map(
      zio.aws.servicecatalog.model.DisassociateProductFromPortfolioResponse.wrap
    ).provideEnvironment(r)
    def deleteServiceAction(request: DeleteServiceActionRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.DeleteServiceActionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DeleteServiceActionRequest,
      DeleteServiceActionResponse
    ]("deleteServiceAction", api.deleteServiceAction)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.DeleteServiceActionResponse.wrap)
      .provideEnvironment(r)
    def searchProvisionedProducts(
        request: SearchProvisionedProductsRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.SearchProvisionedProductsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest,
      SearchProvisionedProductsResponse
    ]("searchProvisionedProducts", api.searchProvisionedProducts)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.SearchProvisionedProductsResponse.wrap)
      .provideEnvironment(r)
    def listBudgetsForResource(request: ListBudgetsForResourceRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.ListBudgetsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest,
      ListBudgetsForResourceResponse
    ]("listBudgetsForResource", api.listBudgetsForResource)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.ListBudgetsForResourceResponse.wrap)
      .provideEnvironment(r)
    def describeConstraint(request: DescribeConstraintRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.DescribeConstraintResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DescribeConstraintRequest,
      DescribeConstraintResponse
    ]("describeConstraint", api.describeConstraint)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.DescribeConstraintResponse.wrap)
      .provideEnvironment(r)
    def disableAWSOrganizationsAccess(
        request: DisableAwsOrganizationsAccessRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.DisableAwsOrganizationsAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DisableAwsOrganizationsAccessRequest,
      DisableAwsOrganizationsAccessResponse
    ]("disableAWSOrganizationsAccess", api.disableAWSOrganizationsAccess)(
      request.buildAwsValue()
    ).map(
      zio.aws.servicecatalog.model.DisableAwsOrganizationsAccessResponse.wrap
    ).provideEnvironment(r)
    def deleteProvisioningArtifact(
        request: DeleteProvisioningArtifactRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.DeleteProvisioningArtifactResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DeleteProvisioningArtifactRequest,
      DeleteProvisioningArtifactResponse
    ]("deleteProvisioningArtifact", api.deleteProvisioningArtifact)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.DeleteProvisioningArtifactResponse.wrap)
      .provideEnvironment(r)
    def updateProvisioningArtifact(
        request: UpdateProvisioningArtifactRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.UpdateProvisioningArtifactResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningArtifactRequest,
      UpdateProvisioningArtifactResponse
    ]("updateProvisioningArtifact", api.updateProvisioningArtifact)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.UpdateProvisioningArtifactResponse.wrap)
      .provideEnvironment(r)
    def importAsProvisionedProduct(
        request: ImportAsProvisionedProductRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.ImportAsProvisionedProductResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ImportAsProvisionedProductRequest,
      ImportAsProvisionedProductResponse
    ]("importAsProvisionedProduct", api.importAsProvisionedProduct)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.ImportAsProvisionedProductResponse.wrap)
      .provideEnvironment(r)
    def updatePortfolio(request: UpdatePortfolioRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.UpdatePortfolioResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioRequest,
      UpdatePortfolioResponse
    ]("updatePortfolio", api.updatePortfolio)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.UpdatePortfolioResponse.wrap)
      .provideEnvironment(r)
    def listLaunchPaths(request: ListLaunchPathsRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.ListLaunchPathsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest,
      ListLaunchPathsResponse
    ]("listLaunchPaths", api.listLaunchPaths)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.ListLaunchPathsResponse.wrap)
      .provideEnvironment(r)
    def listProvisionedProductPlans(
        request: ListProvisionedProductPlansRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.ListProvisionedProductPlansResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansRequest,
      ListProvisionedProductPlansResponse
    ]("listProvisionedProductPlans", api.listProvisionedProductPlans)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.ListProvisionedProductPlansResponse.wrap)
      .provideEnvironment(r)
    def getAWSOrganizationsAccessStatus(
        request: GetAwsOrganizationsAccessStatusRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.GetAwsOrganizationsAccessStatusRequest,
      GetAwsOrganizationsAccessStatusResponse
    ]("getAWSOrganizationsAccessStatus", api.getAWSOrganizationsAccessStatus)(
      request.buildAwsValue()
    ).map(
      zio.aws.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse.wrap
    ).provideEnvironment(r)
    def createTagOption(request: CreateTagOptionRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.CreateTagOptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.CreateTagOptionRequest,
      CreateTagOptionResponse
    ]("createTagOption", api.createTagOption)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.CreateTagOptionResponse.wrap)
      .provideEnvironment(r)
    def describePortfolio(request: DescribePortfolioRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.DescribePortfolioResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioRequest,
      DescribePortfolioResponse
    ]("describePortfolio", api.describePortfolio)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.DescribePortfolioResponse.wrap)
      .provideEnvironment(r)
    def listOrganizationPortfolioAccess(
        request: ListOrganizationPortfolioAccessRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.ListOrganizationPortfolioAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest,
      ListOrganizationPortfolioAccessResponse
    ]("listOrganizationPortfolioAccess", api.listOrganizationPortfolioAccess)(
      request.buildAwsValue()
    ).map(
      zio.aws.servicecatalog.model.ListOrganizationPortfolioAccessResponse.wrap
    ).provideEnvironment(r)
    def describePortfolioShares(request: DescribePortfolioSharesRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.DescribePortfolioSharesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest,
      DescribePortfolioSharesResponse
    ]("describePortfolioShares", api.describePortfolioShares)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.DescribePortfolioSharesResponse.wrap)
      .provideEnvironment(r)
    def updateProvisionedProduct(request: UpdateProvisionedProductRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.UpdateProvisionedProductResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductRequest,
      UpdateProvisionedProductResponse
    ]("updateProvisionedProduct", api.updateProvisionedProduct)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.UpdateProvisionedProductResponse.wrap)
      .provideEnvironment(r)
    def describeProduct(request: DescribeProductRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.DescribeProductResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DescribeProductRequest,
      DescribeProductResponse
    ]("describeProduct", api.describeProduct)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.DescribeProductResponse.wrap)
      .provideEnvironment(r)
    def listPortfoliosForProduct(request: ListPortfoliosForProductRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.ListPortfoliosForProductResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest,
      ListPortfoliosForProductResponse
    ]("listPortfoliosForProduct", api.listPortfoliosForProduct)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.ListPortfoliosForProductResponse.wrap)
      .provideEnvironment(r)
    def listTagOptions(request: ListTagOptionsRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.ListTagOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest,
      ListTagOptionsResponse
    ]("listTagOptions", api.listTagOptions)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.ListTagOptionsResponse.wrap)
      .provideEnvironment(r)
    def notifyTerminateProvisionedProductEngineWorkflowResult(
        request: NotifyTerminateProvisionedProductEngineWorkflowResultRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultRequest,
      NotifyTerminateProvisionedProductEngineWorkflowResultResponse
    ](
      "notifyTerminateProvisionedProductEngineWorkflowResult",
      api.notifyTerminateProvisionedProductEngineWorkflowResult
    )(request.buildAwsValue())
      .map(
        zio.aws.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultResponse.wrap
      )
      .provideEnvironment(r)
    def deleteConstraint(request: DeleteConstraintRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.DeleteConstraintResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DeleteConstraintRequest,
      DeleteConstraintResponse
    ]("deleteConstraint", api.deleteConstraint)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.DeleteConstraintResponse.wrap)
      .provideEnvironment(r)
    def describeProvisionedProductPlan(
        request: DescribeProvisionedProductPlanRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.DescribeProvisionedProductPlanResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductPlanRequest,
      DescribeProvisionedProductPlanResponse
    ]("describeProvisionedProductPlan", api.describeProvisionedProductPlan)(
      request.buildAwsValue()
    ).map(
      zio.aws.servicecatalog.model.DescribeProvisionedProductPlanResponse.wrap
    ).provideEnvironment(r)
    def listRecordHistory(request: ListRecordHistoryRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.ListRecordHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryRequest,
      ListRecordHistoryResponse
    ]("listRecordHistory", api.listRecordHistory)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.ListRecordHistoryResponse.wrap)
      .provideEnvironment(r)
    def listAcceptedPortfolioShares(
        request: ListAcceptedPortfolioSharesRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.ListAcceptedPortfolioSharesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest,
      ListAcceptedPortfolioSharesResponse
    ]("listAcceptedPortfolioShares", api.listAcceptedPortfolioShares)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.ListAcceptedPortfolioSharesResponse.wrap)
      .provideEnvironment(r)
    def deletePortfolioShare(request: DeletePortfolioShareRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.DeletePortfolioShareResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareRequest,
      DeletePortfolioShareResponse
    ]("deletePortfolioShare", api.deletePortfolioShare)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.DeletePortfolioShareResponse.wrap)
      .provideEnvironment(r)
    def describePortfolioShareStatus(
        request: DescribePortfolioShareStatusRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.DescribePortfolioShareStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusRequest,
      DescribePortfolioShareStatusResponse
    ]("describePortfolioShareStatus", api.describePortfolioShareStatus)(
      request.buildAwsValue()
    ).map(
      zio.aws.servicecatalog.model.DescribePortfolioShareStatusResponse.wrap
    ).provideEnvironment(r)
    def acceptPortfolioShare(request: AcceptPortfolioShareRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.AcceptPortfolioShareResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.AcceptPortfolioShareRequest,
      AcceptPortfolioShareResponse
    ]("acceptPortfolioShare", api.acceptPortfolioShare)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.AcceptPortfolioShareResponse.wrap)
      .provideEnvironment(r)
    def describeRecord(request: DescribeRecordRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.DescribeRecordResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DescribeRecordRequest,
      DescribeRecordResponse
    ]("describeRecord", api.describeRecord)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.DescribeRecordResponse.wrap)
      .provideEnvironment(r)
    def createPortfolioShare(request: CreatePortfolioShareRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.CreatePortfolioShareResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareRequest,
      CreatePortfolioShareResponse
    ]("createPortfolioShare", api.createPortfolioShare)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.CreatePortfolioShareResponse.wrap)
      .provideEnvironment(r)
    def disassociateBudgetFromResource(
        request: DisassociateBudgetFromResourceRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.DisassociateBudgetFromResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DisassociateBudgetFromResourceRequest,
      DisassociateBudgetFromResourceResponse
    ]("disassociateBudgetFromResource", api.disassociateBudgetFromResource)(
      request.buildAwsValue()
    ).map(
      zio.aws.servicecatalog.model.DisassociateBudgetFromResourceResponse.wrap
    ).provideEnvironment(r)
    def scanProvisionedProducts(request: ScanProvisionedProductsRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.ScanProvisionedProductsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ScanProvisionedProductsRequest,
      ScanProvisionedProductsResponse
    ]("scanProvisionedProducts", api.scanProvisionedProducts)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.ScanProvisionedProductsResponse.wrap)
      .provideEnvironment(r)
    def notifyProvisionProductEngineWorkflowResult(
        request: NotifyProvisionProductEngineWorkflowResultRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.NotifyProvisionProductEngineWorkflowResultResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.NotifyProvisionProductEngineWorkflowResultRequest,
      NotifyProvisionProductEngineWorkflowResultResponse
    ](
      "notifyProvisionProductEngineWorkflowResult",
      api.notifyProvisionProductEngineWorkflowResult
    )(request.buildAwsValue())
      .map(
        zio.aws.servicecatalog.model.NotifyProvisionProductEngineWorkflowResultResponse.wrap
      )
      .provideEnvironment(r)
    def deleteTagOption(request: DeleteTagOptionRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.DeleteTagOptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DeleteTagOptionRequest,
      DeleteTagOptionResponse
    ]("deleteTagOption", api.deleteTagOption)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.DeleteTagOptionResponse.wrap)
      .provideEnvironment(r)
    def updateServiceAction(request: UpdateServiceActionRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.UpdateServiceActionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.UpdateServiceActionRequest,
      UpdateServiceActionResponse
    ]("updateServiceAction", api.updateServiceAction)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.UpdateServiceActionResponse.wrap)
      .provideEnvironment(r)
    def provisionProduct(request: ProvisionProductRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.ProvisionProductResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ProvisionProductRequest,
      ProvisionProductResponse
    ]("provisionProduct", api.provisionProduct)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.ProvisionProductResponse.wrap)
      .provideEnvironment(r)
    def describeProductView(request: DescribeProductViewRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.DescribeProductViewResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewRequest,
      DescribeProductViewResponse
    ]("describeProductView", api.describeProductView)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.DescribeProductViewResponse.wrap)
      .provideEnvironment(r)
    def describeTagOption(request: DescribeTagOptionRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.DescribeTagOptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DescribeTagOptionRequest,
      DescribeTagOptionResponse
    ]("describeTagOption", api.describeTagOption)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.DescribeTagOptionResponse.wrap)
      .provideEnvironment(r)
    def deleteProvisionedProductPlan(
        request: DeleteProvisionedProductPlanRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.DeleteProvisionedProductPlanResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DeleteProvisionedProductPlanRequest,
      DeleteProvisionedProductPlanResponse
    ]("deleteProvisionedProductPlan", api.deleteProvisionedProductPlan)(
      request.buildAwsValue()
    ).map(
      zio.aws.servicecatalog.model.DeleteProvisionedProductPlanResponse.wrap
    ).provideEnvironment(r)
    def createServiceAction(request: CreateServiceActionRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.CreateServiceActionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.CreateServiceActionRequest,
      CreateServiceActionResponse
    ]("createServiceAction", api.createServiceAction)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.CreateServiceActionResponse.wrap)
      .provideEnvironment(r)
    def listConstraintsForPortfolio(
        request: ListConstraintsForPortfolioRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.ListConstraintsForPortfolioResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest,
      ListConstraintsForPortfolioResponse
    ]("listConstraintsForPortfolio", api.listConstraintsForPortfolio)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.ListConstraintsForPortfolioResponse.wrap)
      .provideEnvironment(r)
    def disassociatePrincipalFromPortfolio(
        request: DisassociatePrincipalFromPortfolioRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.DisassociatePrincipalFromPortfolioResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DisassociatePrincipalFromPortfolioRequest,
      DisassociatePrincipalFromPortfolioResponse
    ](
      "disassociatePrincipalFromPortfolio",
      api.disassociatePrincipalFromPortfolio
    )(request.buildAwsValue())
      .map(
        zio.aws.servicecatalog.model.DisassociatePrincipalFromPortfolioResponse.wrap
      )
      .provideEnvironment(r)
    def listPrincipalsForPortfolio(
        request: ListPrincipalsForPortfolioRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.ListPrincipalsForPortfolioResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest,
      ListPrincipalsForPortfolioResponse
    ]("listPrincipalsForPortfolio", api.listPrincipalsForPortfolio)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.ListPrincipalsForPortfolioResponse.wrap)
      .provideEnvironment(r)
    def enableAWSOrganizationsAccess(
        request: EnableAwsOrganizationsAccessRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.EnableAwsOrganizationsAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.EnableAwsOrganizationsAccessRequest,
      EnableAwsOrganizationsAccessResponse
    ]("enableAWSOrganizationsAccess", api.enableAWSOrganizationsAccess)(
      request.buildAwsValue()
    ).map(
      zio.aws.servicecatalog.model.EnableAwsOrganizationsAccessResponse.wrap
    ).provideEnvironment(r)
    def getProvisionedProductOutputs(
        request: GetProvisionedProductOutputsRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.GetProvisionedProductOutputsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest,
      GetProvisionedProductOutputsResponse
    ]("getProvisionedProductOutputs", api.getProvisionedProductOutputs)(
      request.buildAwsValue()
    ).map(
      zio.aws.servicecatalog.model.GetProvisionedProductOutputsResponse.wrap
    ).provideEnvironment(r)
    def associateServiceActionWithProvisioningArtifact(
        request: AssociateServiceActionWithProvisioningArtifactRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactRequest,
      AssociateServiceActionWithProvisioningArtifactResponse
    ](
      "associateServiceActionWithProvisioningArtifact",
      api.associateServiceActionWithProvisioningArtifact
    )(request.buildAwsValue())
      .map(
        zio.aws.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactResponse.wrap
      )
      .provideEnvironment(r)
    def createProvisionedProductPlan(
        request: CreateProvisionedProductPlanRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.CreateProvisionedProductPlanResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanRequest,
      CreateProvisionedProductPlanResponse
    ]("createProvisionedProductPlan", api.createProvisionedProductPlan)(
      request.buildAwsValue()
    ).map(
      zio.aws.servicecatalog.model.CreateProvisionedProductPlanResponse.wrap
    ).provideEnvironment(r)
    def executeProvisionedProductPlan(
        request: ExecuteProvisionedProductPlanRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.ExecuteProvisionedProductPlanResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductPlanRequest,
      ExecuteProvisionedProductPlanResponse
    ]("executeProvisionedProductPlan", api.executeProvisionedProductPlan)(
      request.buildAwsValue()
    ).map(
      zio.aws.servicecatalog.model.ExecuteProvisionedProductPlanResponse.wrap
    ).provideEnvironment(r)
    def describeProvisionedProduct(
        request: DescribeProvisionedProductRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.DescribeProvisionedProductResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductRequest,
      DescribeProvisionedProductResponse
    ]("describeProvisionedProduct", api.describeProvisionedProduct)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.DescribeProvisionedProductResponse.wrap)
      .provideEnvironment(r)
    def listPortfolios(request: ListPortfoliosRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.ListPortfoliosResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest,
      ListPortfoliosResponse
    ]("listPortfolios", api.listPortfolios)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.ListPortfoliosResponse.wrap)
      .provideEnvironment(r)
    def searchProducts(request: SearchProductsRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.SearchProductsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest,
      SearchProductsResponse
    ]("searchProducts", api.searchProducts)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.SearchProductsResponse.wrap)
      .provideEnvironment(r)
    def updatePortfolioShare(request: UpdatePortfolioShareRequest): IO[
      AwsError,
      zio.aws.servicecatalog.model.UpdatePortfolioShareResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioShareRequest,
      UpdatePortfolioShareResponse
    ]("updatePortfolioShare", api.updatePortfolioShare)(request.buildAwsValue())
      .map(zio.aws.servicecatalog.model.UpdatePortfolioShareResponse.wrap)
      .provideEnvironment(r)
    def describeCopyProductStatus(
        request: DescribeCopyProductStatusRequest
    ): IO[
      AwsError,
      zio.aws.servicecatalog.model.DescribeCopyProductStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.servicecatalog.model.DescribeCopyProductStatusRequest,
      DescribeCopyProductStatusResponse
    ]("describeCopyProductStatus", api.describeCopyProductStatus)(
      request.buildAwsValue()
    ).map(zio.aws.servicecatalog.model.DescribeCopyProductStatusResponse.wrap)
      .provideEnvironment(r)
  }
  def listResourcesForTagOption(request: ListResourcesForTagOptionRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ListResourcesForTagOptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResourcesForTagOption(request))
  def updateTagOption(request: UpdateTagOptionRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.UpdateTagOptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTagOption(request))
  def disassociateTagOptionFromResource(
      request: DisassociateTagOptionFromResourceRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DisassociateTagOptionFromResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateTagOptionFromResource(request))
  def listProvisioningArtifacts(
      request: ListProvisioningArtifactsRequest
  ): ZIO[zio.aws.servicecatalog.ServiceCatalog, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listProvisioningArtifacts(request))
  def associatePrincipalWithPortfolio(
      request: AssociatePrincipalWithPortfolioRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.AssociatePrincipalWithPortfolioResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associatePrincipalWithPortfolio(request))
  def listProvisioningArtifactsForServiceAction(
      request: ListProvisioningArtifactsForServiceActionRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProvisioningArtifactsForServiceAction(request))
  def executeProvisionedProductServiceAction(
      request: ExecuteProvisionedProductServiceActionRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.executeProvisionedProductServiceAction(request))
  def associateProductWithPortfolio(
      request: AssociateProductWithPortfolioRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.AssociateProductWithPortfolioResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateProductWithPortfolio(request))
  def describeServiceAction(request: DescribeServiceActionRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DescribeServiceActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeServiceAction(request))
  def updateProvisionedProductProperties(
      request: UpdateProvisionedProductPropertiesRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProvisionedProductProperties(request))
  def createConstraint(request: CreateConstraintRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.CreateConstraintResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConstraint(request))
  def terminateProvisionedProduct(
      request: TerminateProvisionedProductRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.TerminateProvisionedProductResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.terminateProvisionedProduct(request))
  def listServiceActions(request: ListServiceActionsRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ListServiceActionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServiceActions(request))
  def describeServiceActionExecutionParameters(
      request: DescribeServiceActionExecutionParametersRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DescribeServiceActionExecutionParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeServiceActionExecutionParameters(request))
  def listServiceActionsForProvisioningArtifact(
      request: ListServiceActionsForProvisioningArtifactRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServiceActionsForProvisioningArtifact(request))
  def deleteProduct(request: DeleteProductRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DeleteProductResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProduct(request))
  def createProduct(request: CreateProductRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.CreateProductResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProduct(request))
  def associateTagOptionWithResource(
      request: AssociateTagOptionWithResourceRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.AssociateTagOptionWithResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateTagOptionWithResource(request))
  def associateBudgetWithResource(
      request: AssociateBudgetWithResourceRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.AssociateBudgetWithResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateBudgetWithResource(request))
  def deletePortfolio(request: DeletePortfolioRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DeletePortfolioResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePortfolio(request))
  def updateProduct(request: UpdateProductRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.UpdateProductResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProduct(request))
  def updateConstraint(request: UpdateConstraintRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.UpdateConstraintResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateConstraint(request))
  def copyProduct(request: CopyProductRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.CopyProductResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyProduct(request))
  def describeProvisioningParameters(
      request: DescribeProvisioningParametersRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DescribeProvisioningParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProvisioningParameters(request))
  def batchAssociateServiceActionWithProvisioningArtifact(
      request: BatchAssociateServiceActionWithProvisioningArtifactRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.batchAssociateServiceActionWithProvisioningArtifact(request)
  )
  def listPortfolioAccess(request: ListPortfolioAccessRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ListPortfolioAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPortfolioAccess(request))
  def describeProvisioningArtifact(
      request: DescribeProvisioningArtifactRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DescribeProvisioningArtifactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProvisioningArtifact(request))
  def searchProductsAsAdmin(request: SearchProductsAsAdminRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.SearchProductsAsAdminResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchProductsAsAdmin(request))
  def rejectPortfolioShare(request: RejectPortfolioShareRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.RejectPortfolioShareResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rejectPortfolioShare(request))
  def disassociateServiceActionFromProvisioningArtifact(
      request: DisassociateServiceActionFromProvisioningArtifactRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.disassociateServiceActionFromProvisioningArtifact(request)
  )
  def describeProductAsAdmin(request: DescribeProductAsAdminRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DescribeProductAsAdminResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProductAsAdmin(request))
  def listStackInstancesForProvisionedProduct(
      request: ListStackInstancesForProvisionedProductRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ListStackInstancesForProvisionedProductResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStackInstancesForProvisionedProduct(request))
  def notifyUpdateProvisionedProductEngineWorkflowResult(
      request: NotifyUpdateProvisionedProductEngineWorkflowResultRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.notifyUpdateProvisionedProductEngineWorkflowResult(request)
  )
  def createPortfolio(request: CreatePortfolioRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.CreatePortfolioResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPortfolio(request))
  def createProvisioningArtifact(
      request: CreateProvisioningArtifactRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.CreateProvisioningArtifactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProvisioningArtifact(request))
  def batchDisassociateServiceActionFromProvisioningArtifact(
      request: BatchDisassociateServiceActionFromProvisioningArtifactRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.batchDisassociateServiceActionFromProvisioningArtifact(request)
  )
  def disassociateProductFromPortfolio(
      request: DisassociateProductFromPortfolioRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DisassociateProductFromPortfolioResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateProductFromPortfolio(request))
  def deleteServiceAction(request: DeleteServiceActionRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DeleteServiceActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteServiceAction(request))
  def searchProvisionedProducts(request: SearchProvisionedProductsRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.SearchProvisionedProductsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchProvisionedProducts(request))
  def listBudgetsForResource(request: ListBudgetsForResourceRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ListBudgetsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBudgetsForResource(request))
  def describeConstraint(request: DescribeConstraintRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DescribeConstraintResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConstraint(request))
  def disableAWSOrganizationsAccess(
      request: DisableAwsOrganizationsAccessRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DisableAwsOrganizationsAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableAWSOrganizationsAccess(request))
  def deleteProvisioningArtifact(
      request: DeleteProvisioningArtifactRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DeleteProvisioningArtifactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProvisioningArtifact(request))
  def updateProvisioningArtifact(
      request: UpdateProvisioningArtifactRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.UpdateProvisioningArtifactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProvisioningArtifact(request))
  def importAsProvisionedProduct(
      request: ImportAsProvisionedProductRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ImportAsProvisionedProductResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importAsProvisionedProduct(request))
  def updatePortfolio(request: UpdatePortfolioRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.UpdatePortfolioResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePortfolio(request))
  def listLaunchPaths(request: ListLaunchPathsRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ListLaunchPathsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLaunchPaths(request))
  def listProvisionedProductPlans(
      request: ListProvisionedProductPlansRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ListProvisionedProductPlansResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProvisionedProductPlans(request))
  def getAWSOrganizationsAccessStatus(
      request: GetAwsOrganizationsAccessStatusRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAWSOrganizationsAccessStatus(request))
  def createTagOption(request: CreateTagOptionRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.CreateTagOptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTagOption(request))
  def describePortfolio(request: DescribePortfolioRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DescribePortfolioResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePortfolio(request))
  def listOrganizationPortfolioAccess(
      request: ListOrganizationPortfolioAccessRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ListOrganizationPortfolioAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOrganizationPortfolioAccess(request))
  def describePortfolioShares(request: DescribePortfolioSharesRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DescribePortfolioSharesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePortfolioShares(request))
  def updateProvisionedProduct(request: UpdateProvisionedProductRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.UpdateProvisionedProductResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProvisionedProduct(request))
  def describeProduct(request: DescribeProductRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DescribeProductResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProduct(request))
  def listPortfoliosForProduct(request: ListPortfoliosForProductRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ListPortfoliosForProductResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPortfoliosForProduct(request))
  def listTagOptions(request: ListTagOptionsRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ListTagOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagOptions(request))
  def notifyTerminateProvisionedProductEngineWorkflowResult(
      request: NotifyTerminateProvisionedProductEngineWorkflowResultRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.notifyTerminateProvisionedProductEngineWorkflowResult(request)
  )
  def deleteConstraint(request: DeleteConstraintRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DeleteConstraintResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConstraint(request))
  def describeProvisionedProductPlan(
      request: DescribeProvisionedProductPlanRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DescribeProvisionedProductPlanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProvisionedProductPlan(request))
  def listRecordHistory(request: ListRecordHistoryRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ListRecordHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRecordHistory(request))
  def listAcceptedPortfolioShares(
      request: ListAcceptedPortfolioSharesRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ListAcceptedPortfolioSharesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAcceptedPortfolioShares(request))
  def deletePortfolioShare(request: DeletePortfolioShareRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DeletePortfolioShareResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePortfolioShare(request))
  def describePortfolioShareStatus(
      request: DescribePortfolioShareStatusRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DescribePortfolioShareStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePortfolioShareStatus(request))
  def acceptPortfolioShare(request: AcceptPortfolioShareRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.AcceptPortfolioShareResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptPortfolioShare(request))
  def describeRecord(request: DescribeRecordRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DescribeRecordResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRecord(request))
  def createPortfolioShare(request: CreatePortfolioShareRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.CreatePortfolioShareResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPortfolioShare(request))
  def disassociateBudgetFromResource(
      request: DisassociateBudgetFromResourceRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DisassociateBudgetFromResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateBudgetFromResource(request))
  def scanProvisionedProducts(request: ScanProvisionedProductsRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ScanProvisionedProductsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.scanProvisionedProducts(request))
  def notifyProvisionProductEngineWorkflowResult(
      request: NotifyProvisionProductEngineWorkflowResultRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.NotifyProvisionProductEngineWorkflowResultResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.notifyProvisionProductEngineWorkflowResult(request))
  def deleteTagOption(request: DeleteTagOptionRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DeleteTagOptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTagOption(request))
  def updateServiceAction(request: UpdateServiceActionRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.UpdateServiceActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateServiceAction(request))
  def provisionProduct(request: ProvisionProductRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ProvisionProductResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.provisionProduct(request))
  def describeProductView(request: DescribeProductViewRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DescribeProductViewResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProductView(request))
  def describeTagOption(request: DescribeTagOptionRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DescribeTagOptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTagOption(request))
  def deleteProvisionedProductPlan(
      request: DeleteProvisionedProductPlanRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DeleteProvisionedProductPlanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProvisionedProductPlan(request))
  def createServiceAction(request: CreateServiceActionRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.CreateServiceActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createServiceAction(request))
  def listConstraintsForPortfolio(
      request: ListConstraintsForPortfolioRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ListConstraintsForPortfolioResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listConstraintsForPortfolio(request))
  def disassociatePrincipalFromPortfolio(
      request: DisassociatePrincipalFromPortfolioRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DisassociatePrincipalFromPortfolioResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociatePrincipalFromPortfolio(request))
  def listPrincipalsForPortfolio(
      request: ListPrincipalsForPortfolioRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ListPrincipalsForPortfolioResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPrincipalsForPortfolio(request))
  def enableAWSOrganizationsAccess(
      request: EnableAwsOrganizationsAccessRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.EnableAwsOrganizationsAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableAWSOrganizationsAccess(request))
  def getProvisionedProductOutputs(
      request: GetProvisionedProductOutputsRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.GetProvisionedProductOutputsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getProvisionedProductOutputs(request))
  def associateServiceActionWithProvisioningArtifact(
      request: AssociateServiceActionWithProvisioningArtifactRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.associateServiceActionWithProvisioningArtifact(request)
  )
  def createProvisionedProductPlan(
      request: CreateProvisionedProductPlanRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.CreateProvisionedProductPlanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProvisionedProductPlan(request))
  def executeProvisionedProductPlan(
      request: ExecuteProvisionedProductPlanRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ExecuteProvisionedProductPlanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.executeProvisionedProductPlan(request))
  def describeProvisionedProduct(
      request: DescribeProvisionedProductRequest
  ): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DescribeProvisionedProductResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProvisionedProduct(request))
  def listPortfolios(request: ListPortfoliosRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.ListPortfoliosResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPortfolios(request))
  def searchProducts(request: SearchProductsRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.SearchProductsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchProducts(request))
  def updatePortfolioShare(request: UpdatePortfolioShareRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.UpdatePortfolioShareResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePortfolioShare(request))
  def describeCopyProductStatus(request: DescribeCopyProductStatusRequest): ZIO[
    zio.aws.servicecatalog.ServiceCatalog,
    AwsError,
    zio.aws.servicecatalog.model.DescribeCopyProductStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCopyProductStatus(request))
}
