package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TerminateProvisionedProductResponse(
    recordDetail: Optional[zio.aws.servicecatalog.model.RecordDetail] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductResponse = {
    import TerminateProvisionedProductResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductResponse
      .builder()
      .optionallyWith(recordDetail.map(value => value.buildAwsValue()))(
        _.recordDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.TerminateProvisionedProductResponse.ReadOnly =
    zio.aws.servicecatalog.model.TerminateProvisionedProductResponse
      .wrap(buildAwsValue())
}
object TerminateProvisionedProductResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.TerminateProvisionedProductResponse =
      zio.aws.servicecatalog.model.TerminateProvisionedProductResponse(
        recordDetail.map(value => value.asEditable)
      )
    def recordDetail
        : Optional[zio.aws.servicecatalog.model.RecordDetail.ReadOnly]
    def getRecordDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.RecordDetail.ReadOnly
    ] = AwsError.unwrapOptionField("recordDetail", recordDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductResponse
  ) extends zio.aws.servicecatalog.model.TerminateProvisionedProductResponse.ReadOnly {
    override val recordDetail
        : Optional[zio.aws.servicecatalog.model.RecordDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordDetail())
        .map(value => zio.aws.servicecatalog.model.RecordDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductResponse
  ): zio.aws.servicecatalog.model.TerminateProvisionedProductResponse.ReadOnly =
    new Wrapper(impl)
}
