package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.servicecatalog.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters._
final case class Tag(key: TagKey, value: TagValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.Tag
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .value(TagValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.Tag.ReadOnly =
    zio.aws.servicecatalog.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.Tag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.Tag =
      zio.aws.servicecatalog.model.Tag(key, value)
    def key: TagKey
    def value: TagValue
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, TagValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.Tag
  ) extends zio.aws.servicecatalog.model.Tag.ReadOnly {
    override val key: TagKey =
      zio.aws.servicecatalog.model.primitives.TagKey(impl.key())
    override val value: TagValue =
      zio.aws.servicecatalog.model.primitives.TagValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.Tag
  ): zio.aws.servicecatalog.model.Tag.ReadOnly = new Wrapper(impl)
}
