package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait StackSetOperationType {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.StackSetOperationType
}
object StackSetOperationType {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.StackSetOperationType
  ): zio.aws.servicecatalog.model.StackSetOperationType = value match {
    case software.amazon.awssdk.services.servicecatalog.model.StackSetOperationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.StackSetOperationType.CREATE =>
      val r = CREATE
      r
    case software.amazon.awssdk.services.servicecatalog.model.StackSetOperationType.UPDATE =>
      val r = UPDATE
      r
    case software.amazon.awssdk.services.servicecatalog.model.StackSetOperationType.DELETE =>
      val r = DELETE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.StackSetOperationType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.StackSetOperationType =
      software.amazon.awssdk.services.servicecatalog.model.StackSetOperationType.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE
      extends zio.aws.servicecatalog.model.StackSetOperationType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.StackSetOperationType =
      software.amazon.awssdk.services.servicecatalog.model.StackSetOperationType.CREATE
  }
  case object UPDATE
      extends zio.aws.servicecatalog.model.StackSetOperationType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.StackSetOperationType =
      software.amazon.awssdk.services.servicecatalog.model.StackSetOperationType.UPDATE
  }
  case object DELETE
      extends zio.aws.servicecatalog.model.StackSetOperationType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.StackSetOperationType =
      software.amazon.awssdk.services.servicecatalog.model.StackSetOperationType.DELETE
  }
}
