package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{Message, AccountId}
import scala.jdk.CollectionConverters._
final case class ShareError(
    accounts: Optional[Iterable[AccountId]] = Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    error: Optional[zio.aws.servicecatalog.model.primitives.Error] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ShareError = {
    import ShareError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ShareError
      .builder()
      .optionallyWith(
        accounts.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accounts)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        error.map(value =>
          zio.aws.servicecatalog.model.primitives.Error
            .unwrap(value): java.lang.String
        )
      )(_.error)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ShareError.ReadOnly =
    zio.aws.servicecatalog.model.ShareError.wrap(buildAwsValue())
}
object ShareError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ShareError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ShareError =
      zio.aws.servicecatalog.model.ShareError(
        accounts.map(value => value),
        message.map(value => value),
        error.map(value => value)
      )
    def accounts: Optional[List[AccountId]]
    def message: Optional[Message]
    def error: Optional[zio.aws.servicecatalog.model.primitives.Error]
    def getAccounts: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accounts", accounts)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getError
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.primitives.Error] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ShareError
  ) extends zio.aws.servicecatalog.model.ShareError.ReadOnly {
    override val accounts: Optional[List[AccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.accounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.primitives.AccountId(item)
        }.toList
      )
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.servicecatalog.model.primitives.Message(value))
    override val error
        : Optional[zio.aws.servicecatalog.model.primitives.Error] =
      zio.aws.core.internal
        .optionalFromNullable(impl.error())
        .map(value => zio.aws.servicecatalog.model.primitives.Error(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ShareError
  ): zio.aws.servicecatalog.model.ShareError.ReadOnly = new Wrapper(impl)
}
