package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ProductViewFilterValue,
  PageToken,
  PageSize,
  Id
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchProductsAsAdminRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    portfolioId: Optional[Id] = Optional.Absent,
    filters: Optional[
      Map[zio.aws.servicecatalog.model.ProductViewFilterBy, Iterable[
        ProductViewFilterValue
      ]]
    ] = Optional.Absent,
    sortBy: Optional[zio.aws.servicecatalog.model.ProductViewSortBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.servicecatalog.model.SortOrder] =
      Optional.Absent,
    pageToken: Optional[PageToken] = Optional.Absent,
    pageSize: Optional[PageSize] = Optional.Absent,
    productSource: Optional[zio.aws.servicecatalog.model.ProductSource] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest = {
    import SearchProductsAsAdminRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(
        portfolioId.map(value => Id.unwrap(value): java.lang.String)
      )(_.portfolioId)
      .optionallyWith(
        filters.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                ProductViewFilterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.filtersWithStrings)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(productSource.map(value => value.unwrap))(_.productSource)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.SearchProductsAsAdminRequest.ReadOnly =
    zio.aws.servicecatalog.model.SearchProductsAsAdminRequest
      .wrap(buildAwsValue())
}
object SearchProductsAsAdminRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.SearchProductsAsAdminRequest =
      zio.aws.servicecatalog.model.SearchProductsAsAdminRequest(
        acceptLanguage.map(value => value),
        portfolioId.map(value => value),
        filters.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        pageToken.map(value => value),
        pageSize.map(value => value),
        productSource.map(value => value)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def portfolioId: Optional[Id]
    def filters
        : Optional[Map[zio.aws.servicecatalog.model.ProductViewFilterBy, List[
          ProductViewFilterValue
        ]]]
    def sortBy: Optional[zio.aws.servicecatalog.model.ProductViewSortBy]
    def sortOrder: Optional[zio.aws.servicecatalog.model.SortOrder]
    def pageToken: Optional[PageToken]
    def pageSize: Optional[PageSize]
    def productSource: Optional[zio.aws.servicecatalog.model.ProductSource]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getPortfolioId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("portfolioId", portfolioId)
    def getFilters: ZIO[Any, AwsError, Map[
      zio.aws.servicecatalog.model.ProductViewFilterBy,
      List[ProductViewFilterValue]
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.ProductViewSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getProductSource
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.ProductSource] =
      AwsError.unwrapOptionField("productSource", productSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest
  ) extends zio.aws.servicecatalog.model.SearchProductsAsAdminRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val portfolioId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.portfolioId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val filters
        : Optional[Map[zio.aws.servicecatalog.model.ProductViewFilterBy, List[
          ProductViewFilterValue
        ]]] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.servicecatalog.model.ProductViewFilterBy
              .wrap(key) -> value.asScala.map { item =>
              zio.aws.servicecatalog.model.primitives
                .ProductViewFilterValue(item)
            }.toList
          })
          .toMap
      )
    override val sortBy
        : Optional[zio.aws.servicecatalog.model.ProductViewSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.servicecatalog.model.ProductViewSortBy.wrap(value)
        )
    override val sortOrder: Optional[zio.aws.servicecatalog.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.servicecatalog.model.SortOrder.wrap(value))
    override val pageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
    override val pageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => zio.aws.servicecatalog.model.primitives.PageSize(value))
    override val productSource
        : Optional[zio.aws.servicecatalog.model.ProductSource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productSource())
        .map(value => zio.aws.servicecatalog.model.ProductSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest
  ): zio.aws.servicecatalog.model.SearchProductsAsAdminRequest.ReadOnly =
    new Wrapper(impl)
}
