package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  IdempotencyToken,
  EngineWorkflowFailureReason,
  Id,
  EngineWorkflowToken
}
import scala.jdk.CollectionConverters._
final case class NotifyTerminateProvisionedProductEngineWorkflowResultRequest(
    workflowToken: EngineWorkflowToken,
    recordId: Id,
    status: zio.aws.servicecatalog.model.EngineWorkflowStatus,
    failureReason: Optional[EngineWorkflowFailureReason] = Optional.Absent,
    idempotencyToken: IdempotencyToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultRequest = {
    import NotifyTerminateProvisionedProductEngineWorkflowResultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultRequest
      .builder()
      .workflowToken(
        EngineWorkflowToken.unwrap(workflowToken): java.lang.String
      )
      .recordId(Id.unwrap(recordId): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        failureReason.map(value =>
          EngineWorkflowFailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .idempotencyToken(
        IdempotencyToken.unwrap(idempotencyToken): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultRequest.ReadOnly =
    zio.aws.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultRequest
      .wrap(buildAwsValue())
}
object NotifyTerminateProvisionedProductEngineWorkflowResultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultRequest =
      zio.aws.servicecatalog.model
        .NotifyTerminateProvisionedProductEngineWorkflowResultRequest(
          workflowToken,
          recordId,
          status,
          failureReason.map(value => value),
          idempotencyToken
        )
    def workflowToken: EngineWorkflowToken
    def recordId: Id
    def status: zio.aws.servicecatalog.model.EngineWorkflowStatus
    def failureReason: Optional[EngineWorkflowFailureReason]
    def idempotencyToken: IdempotencyToken
    def getWorkflowToken: ZIO[Any, Nothing, EngineWorkflowToken] =
      ZIO.succeed(workflowToken)
    def getRecordId: ZIO[Any, Nothing, Id] = ZIO.succeed(recordId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.servicecatalog.model.EngineWorkflowStatus] =
      ZIO.succeed(status)
    def getFailureReason: ZIO[Any, AwsError, EngineWorkflowFailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getIdempotencyToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultRequest
  ) extends zio.aws.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultRequest.ReadOnly {
    override val workflowToken: EngineWorkflowToken =
      zio.aws.servicecatalog.model.primitives
        .EngineWorkflowToken(impl.workflowToken())
    override val recordId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.recordId())
    override val status: zio.aws.servicecatalog.model.EngineWorkflowStatus =
      zio.aws.servicecatalog.model.EngineWorkflowStatus.wrap(impl.status())
    override val failureReason: Optional[EngineWorkflowFailureReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReason())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .EngineWorkflowFailureReason(value)
        )
    override val idempotencyToken: IdempotencyToken =
      zio.aws.servicecatalog.model.primitives
        .IdempotencyToken(impl.idempotencyToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultRequest
  ): zio.aws.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultRequest.ReadOnly =
    new Wrapper(impl)
}
