package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListTagOptionsResponse(
    tagOptionDetails: Optional[
      Iterable[zio.aws.servicecatalog.model.TagOptionDetail]
    ] = Optional.Absent,
    pageToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse = {
    import ListTagOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse
      .builder()
      .optionallyWith(
        tagOptionDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagOptionDetails)
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ListTagOptionsResponse.ReadOnly =
    zio.aws.servicecatalog.model.ListTagOptionsResponse.wrap(buildAwsValue())
}
object ListTagOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ListTagOptionsResponse =
      zio.aws.servicecatalog.model.ListTagOptionsResponse(
        tagOptionDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pageToken.map(value => value)
      )
    def tagOptionDetails
        : Optional[List[zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly]]
    def pageToken: Optional[PageToken]
    def getTagOptionDetails: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("tagOptionDetails", tagOptionDetails)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse
  ) extends zio.aws.servicecatalog.model.ListTagOptionsResponse.ReadOnly {
    override val tagOptionDetails: Optional[
      List[zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tagOptionDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.TagOptionDetail.wrap(item)
        }.toList
      )
    override val pageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse
  ): zio.aws.servicecatalog.model.ListTagOptionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
