package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{
  PageToken,
  PageSize,
  Id,
  AcceptLanguage
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListProvisionedProductPlansRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    provisionProductId: Optional[Id] = Optional.Absent,
    pageSize: Optional[PageSize] = Optional.Absent,
    pageToken: Optional[PageToken] = Optional.Absent,
    accessLevelFilter: Optional[
      zio.aws.servicecatalog.model.AccessLevelFilter
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansRequest = {
    import ListProvisionedProductPlansRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(
        provisionProductId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisionProductId)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .optionallyWith(accessLevelFilter.map(value => value.buildAwsValue()))(
        _.accessLevelFilter
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListProvisionedProductPlansRequest.ReadOnly =
    zio.aws.servicecatalog.model.ListProvisionedProductPlansRequest
      .wrap(buildAwsValue())
}
object ListProvisionedProductPlansRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListProvisionedProductPlansRequest =
      zio.aws.servicecatalog.model.ListProvisionedProductPlansRequest(
        acceptLanguage.map(value => value),
        provisionProductId.map(value => value),
        pageSize.map(value => value),
        pageToken.map(value => value),
        accessLevelFilter.map(value => value.asEditable)
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def provisionProductId: Optional[Id]
    def pageSize: Optional[PageSize]
    def pageToken: Optional[PageToken]
    def accessLevelFilter
        : Optional[zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProvisionProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("provisionProductId", provisionProductId)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getAccessLevelFilter: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly
    ] = AwsError.unwrapOptionField("accessLevelFilter", accessLevelFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansRequest
  ) extends zio.aws.servicecatalog.model.ListProvisionedProductPlansRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val provisionProductId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionProductId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val pageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => zio.aws.servicecatalog.model.primitives.PageSize(value))
    override val pageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
    override val accessLevelFilter
        : Optional[zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessLevelFilter())
        .map(value =>
          zio.aws.servicecatalog.model.AccessLevelFilter.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansRequest
  ): zio.aws.servicecatalog.model.ListProvisionedProductPlansRequest.ReadOnly =
    new Wrapper(impl)
}
