package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.servicecatalog.model.primitives.{Id, BudgetName}
import scala.jdk.CollectionConverters._
final case class DisassociateBudgetFromResourceRequest(
    budgetName: BudgetName,
    resourceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DisassociateBudgetFromResourceRequest = {
    import DisassociateBudgetFromResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DisassociateBudgetFromResourceRequest
      .builder()
      .budgetName(BudgetName.unwrap(budgetName): java.lang.String)
      .resourceId(Id.unwrap(resourceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DisassociateBudgetFromResourceRequest.ReadOnly =
    zio.aws.servicecatalog.model.DisassociateBudgetFromResourceRequest
      .wrap(buildAwsValue())
}
object DisassociateBudgetFromResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DisassociateBudgetFromResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DisassociateBudgetFromResourceRequest =
      zio.aws.servicecatalog.model
        .DisassociateBudgetFromResourceRequest(budgetName, resourceId)
    def budgetName: BudgetName
    def resourceId: Id
    def getBudgetName: ZIO[Any, Nothing, BudgetName] = ZIO.succeed(budgetName)
    def getResourceId: ZIO[Any, Nothing, Id] = ZIO.succeed(resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DisassociateBudgetFromResourceRequest
  ) extends zio.aws.servicecatalog.model.DisassociateBudgetFromResourceRequest.ReadOnly {
    override val budgetName: BudgetName =
      zio.aws.servicecatalog.model.primitives.BudgetName(impl.budgetName())
    override val resourceId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.resourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DisassociateBudgetFromResourceRequest
  ): zio.aws.servicecatalog.model.DisassociateBudgetFromResourceRequest.ReadOnly =
    new Wrapper(impl)
}
